/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.api.registry;

import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.class_2960;

public class BehaviourRegistry {
    private static final Map<class_2960, BehaviourType<? extends Behaviour<?>, ?>> behaviourMap = new Object2ObjectOpenHashMap();

    public static <T extends Behaviour<E>, E> BehaviourType<T, E> registerBehaviour(class_2960 resourceLocation, Class<T> type) {
        Class<E> configType = BehaviourRegistry.inferConfigType(type);
        BehaviourType<T, E> behaviourType = new BehaviourType<T, E>(resourceLocation, type, configType);
        behaviourMap.put(resourceLocation, behaviourType);
        return behaviourType;
    }

    private static <E> Class<E> inferConfigType(Class<? extends Behaviour<?>> behaviour) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = behaviour.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    public static <T extends Behaviour<E>, E> BehaviourType<T, E> getType(class_2960 key) {
        BehaviourType<Behaviour<?>, ?> info = behaviourMap.get(key);
        if (info == null) {
            Filament.LOGGER.error("Could not find behaviour " + String.valueOf(key));
            return null;
        }
        return behaviourMap.get(info.id());
    }
}

