/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.block.Lever;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import java.util.function.BiConsumer;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Button
implements BlockBehaviour<Config> {
    private final Config config;

    public Button(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_1269 useWithoutItem(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (((Boolean)state.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
            return class_1269.field_21466;
        }
        this.press(state, level, pos, player);
        return class_1269.field_5812;
    }

    @Override
    public void onExplosionHit(class_2680 state, class_3218 level, class_2338 pos, class_1927 explosion, BiConsumer<class_1799, class_2338> dropConsumer) {
        if (explosion.method_60274() && !((Boolean)state.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
            this.press(state, (class_1937)level, pos, null);
        }
    }

    public void press(class_2680 state, class_1937 level, class_2338 pos, @Nullable class_1657 player) {
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2269.field_10729, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(state, level, pos);
        level.method_39279(pos, state.method_26204(), this.config.ticksToStayPressed.getValue(state).intValue());
        this.playSound((class_1936)level, pos, true);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28174, pos);
    }

    protected void playSound(class_1936 level, class_2338 pos, boolean on) {
        level.method_45447(null, pos, this.getSound(on), class_3419.field_15245);
    }

    protected class_3414 getSound(boolean on) {
        return on ? class_3414.method_47908((class_2960)this.config.clickOnSound) : class_3414.method_47908((class_2960)this.config.clickOffSound);
    }

    @Override
    public void affectNeighborsAfterRemoval(class_2680 state, class_1937 level, class_2338 pos, class_2680 blockState2, boolean movedByPiston) {
        if (!movedByPiston && ((Boolean)state.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
            this.updateNeighbours(state, level, pos);
        }
    }

    @Override
    public int getSignal(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)class_2269.field_10729) != false ? this.config.powerlevel.getValue(state) : 0;
    }

    @Override
    public int getDirectSignal(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)class_2269.field_10729) != false && Lever.getConnectedDirection(state) == direction ? this.config.powerlevel.getValue(state) : 0;
    }

    @Override
    public boolean isSignalSource(class_2680 state) {
        return true;
    }

    @Override
    public void tick(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
            this.pressCheck(state, (class_1937)level, pos);
        }
    }

    @Override
    public void entityInside(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (!level.method_8608() && this.config.canBeActivatedByArrows.getValue(state).booleanValue() && !((Boolean)state.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
            this.pressCheck(state, level, pos);
        }
    }

    protected void pressCheck(class_2680 state, class_1937 level, class_2338 pos) {
        boolean isPowered;
        class_1665 abstractArrow = this.config.canBeActivatedByArrows.getValue(state) != false ? (class_1665)level.method_18467(class_1665.class, state.method_26218((class_1922)level, pos).method_1107().method_996(pos)).stream().findFirst().orElse(null) : null;
        boolean hasArrowInside = abstractArrow != null;
        if (hasArrowInside != (isPowered = ((Boolean)state.method_11654((class_2769)class_2269.field_10729)).booleanValue())) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2269.field_10729, (Comparable)Boolean.valueOf(hasArrowInside)), 3);
            this.updateNeighbours(state, level, pos);
            this.playSound((class_1936)level, pos, hasArrowInside);
            level.method_33596((class_1297)abstractArrow, (class_6880)(hasArrowInside ? class_5712.field_28174 : class_5712.field_28175), pos);
        }
        if (hasArrowInside) {
            level.method_39279(pos, state.method_26204(), this.config.ticksToStayPressed.getValue(state).intValue());
        }
    }

    private void updateNeighbours(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        level.method_8452(blockPos, blockState.method_26204());
        level.method_8452(blockPos.method_10093(Lever.getConnectedDirection(blockState).method_10153()), blockState.method_26204());
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2269.field_11177, class_2269.field_10729, class_2269.field_11007});
    }

    public static class Config {
        public BlockStateMappedProperty<Integer> powerlevel = BlockStateMappedProperty.of(15);
        public BlockStateMappedProperty<Integer> ticksToStayPressed = BlockStateMappedProperty.of(100);
        public BlockStateMappedProperty<Boolean> canBeActivatedByArrows = BlockStateMappedProperty.of(true);
        public class_2960 clickOnSound = class_3417.field_14699.method_14833();
        public class_2960 clickOffSound = class_3417.field_15105.method_14833();
    }
}

