/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.AsyncTickingBlockBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.data.properties.RangedValue;
import de.tomalbrc.filament.data.properties.RangedVector3f;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ParticleEmitter
implements BlockBehaviour<Config>,
AsyncTickingBlockBehaviour {
    private Config config;
    private final transient Map<ParticleEmitterElement, class_2394> decoded = new Reference2ObjectOpenHashMap();

    public ParticleEmitter(Config config) {
        this.config = config;
    }

    private class_2394 decode(ParticleEmitterElement element) {
        DataResult res = class_2398.field_25125.decode((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)Filament.SERVER.method_30611()), (Object)element.particle);
        if (res.isSuccess()) {
            return (class_2394)((Pair)res.getOrThrow()).getFirst();
        }
        return class_2398.field_11231;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void tickAsync(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (this.config.enabled.getValue(blockState).booleanValue() && this.config.elements != null && !this.config.elements.isEmpty()) {
            for (ParticleEmitterElement element : this.config.elements) {
                if (!element.enabled.getValue(blockState).booleanValue() || (serverLevel.method_8510() % 1000000L + blockPos.method_10063()) % (long)element.interval.getValue(blockState).intValue() != 0L || this.decoded.computeIfAbsent(element, key -> this.decode(element)) == null) continue;
                this.emit(blockState, serverLevel, blockPos, randomSource, element);
            }
        }
    }

    private void emit(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource, ParticleEmitterElement element) {
        class_243 pos = blockPos.method_46558();
        Vector3f offset = element.offset.random(randomSource);
        Vector3f delta = element.delta.random(randomSource);
        serverLevel.method_14199(this.decoded.get(element), pos.field_1352 + (double)offset.x, pos.field_1351 + (double)offset.y, pos.field_1350 + (double)offset.z, (int)element.count.randomValue(randomSource), (double)delta.x, (double)delta.y, (double)delta.z, element.speed.randomValue(randomSource));
    }

    public static class Config {
        BlockStateMappedProperty<Boolean> enabled = BlockStateMappedProperty.of(true);
        public List<ParticleEmitterElement> elements;
    }

    public static class ParticleEmitterElement {
        BlockStateMappedProperty<Boolean> enabled = BlockStateMappedProperty.of(true);
        BlockStateMappedProperty<Integer> interval = BlockStateMappedProperty.of(1);
        JsonElement particle;
        RangedVector3f offset = new RangedVector3f();
        RangedValue count = new RangedValue(0.0);
        RangedVector3f delta = new RangedVector3f();
        RangedValue speed = new RangedValue(0.0);
    }
}

