/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import de.tomalbrc.filament.api.behaviour.ContainerLike;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.util.FilamentContainer;
import de.tomalbrc.filament.util.TextUtil;
import de.tomalbrc.filament.util.Util;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4838;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.class_9288;
import net.minecraft.class_9297;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Container
implements DecorationBehaviour<Config>,
ContainerLike {
    public FilamentContainer container;
    public class_5321<class_52> lootTable;
    public long lootTableSeed;
    private final Config config;

    public Container(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void init(DecorationBlockEntity blockEntity) {
        this.container = new FilamentContainer(blockEntity, this.config.size, this.config.purge);
        class_1799 item = blockEntity.getItem();
        if (item.method_57826(class_9334.field_49622)) {
            Objects.requireNonNull((class_9288)blockEntity.getItem().method_57824(class_9334.field_49622)).method_57492(this.container.field_5828);
        }
        if (this.config.openAnimation != null) {
            this.container.setOpenCallback(() -> blockEntity.getOrCreateHolder().playAnimation(this.config.openAnimation, 2));
        }
        if (this.config.closeAnimation != null) {
            this.container.setCloseCallback(() -> blockEntity.getOrCreateHolder().playAnimation(this.config.closeAnimation, 2));
        }
    }

    public static class_2338 chestConnectedBlockPos(class_2338 blockPos, class_2680 blockState) {
        class_2350 direction = class_2281.method_9758((class_2680)blockState);
        return blockPos.method_10093(direction);
    }

    @Override
    public void write(class_2487 output, class_7225.class_7874 lookup, DecorationBlockEntity decorationBlockEntity) {
        if (!this.container.method_54872(output)) {
            output.method_10566("Container", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.container.field_5828, (class_7225.class_7874)lookup));
        }
    }

    @Override
    public void read(class_2487 input, class_7225.class_7874 lookup, DecorationBlockEntity decorationBlockEntity) {
        if (!this.container.method_54871(input) && input.method_10545("Container")) {
            class_1262.method_5429((class_2487)input.method_10562("Container"), (class_2371)this.container.field_5828, (class_7225.class_7874)lookup);
        }
    }

    @Override
    public class_1269 interact(class_3222 player, class_1268 hand, class_243 location, DecorationBlockEntity decorationBlockEntity) {
        if (!player.method_21823()) {
            class_2561 containerName;
            class_2561 class_25612 = containerName = this.customName() != null && this.showCustomName() ? this.customName() : TextUtil.formatText(this.config.name);
            if (!this.config.titlePrefix.isEmpty()) {
                containerName = class_2561.method_43473().method_10852(TextUtil.formatText(this.config.titlePrefix)).method_10852(containerName);
            }
            player.method_17355((class_3908)new class_747((id, inventory, p) -> Util.createMenu((class_1263)this.container, id, p), containerName));
            if (this.config.angerPiglins) {
                class_4838.method_24733((class_1657)player, (boolean)true);
            }
            decorationBlockEntity.method_5431();
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    @Override
    public void destroy(DecorationBlockEntity decorationBlockEntity, boolean dropItem) {
        this.container.setValid(false);
        if (!this.config.canPickup) {
            class_1264.method_5451((class_1937)decorationBlockEntity.method_10997(), (class_2338)decorationBlockEntity.method_11016(), (class_1263)this.container);
        }
    }

    @Override
    public void modifyDrop(DecorationBlockEntity blockEntity, class_1799 itemStack) {
        if (this.config.canPickup) {
            itemStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(this.container.method_54454()));
        }
    }

    @Override
    public void applyImplicitComponents(DecorationBlockEntity decorationBlockEntity, class_2586.class_9473 dataComponentGetter) {
        ((class_9288)dataComponentGetter.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(this.container.field_5828);
        class_9297 seededContainerLoot = (class_9297)dataComponentGetter.method_58694(class_9334.field_49626);
        if (seededContainerLoot != null) {
            this.lootTable = seededContainerLoot.comp_2414();
            this.lootTableSeed = seededContainerLoot.comp_2415();
        }
    }

    @Override
    public void collectImplicitComponents(DecorationBlockEntity decorationBlockEntity, class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493((List)this.container.field_5828));
        if (this.lootTable != null) {
            builder.method_57840(class_9334.field_49626, (Object)new class_9297(this.lootTable, this.lootTableSeed));
        }
    }

    public static class_3917<?> estimateMenuType(int size) {
        if (size <= 5) {
            return class_3917.field_17337;
        }
        int rows = (size + 8) / 9;
        return switch (Math.min(rows, 6)) {
            case 1 -> class_3917.field_18664;
            case 2 -> class_3917.field_18665;
            case 3 -> class_3917.field_17326;
            case 4 -> class_3917.field_18666;
            case 5 -> class_3917.field_18667;
            default -> class_3917.field_17327;
        };
    }

    @Override
    public class_2561 customName() {
        return (class_2561)this.container.getBlockEntity().method_58693().method_57829(class_9334.field_49631);
    }

    @Override
    public class_1263 container() {
        return this.container;
    }

    @Override
    public boolean showCustomName() {
        return this.config.showCustomName;
    }

    @Override
    public boolean hopperDropperSupport() {
        return this.config.hopperDropperSupport;
    }

    @Override
    public boolean canPickUp() {
        return this.config.canPickup;
    }

    @Override
    public void removeComponentsFromTag(DecorationBlockEntity decorationBlockEntity, class_2487 valueOutput, class_7225.class_7874 lookup) {
        valueOutput.method_10551("LootTable");
        valueOutput.method_10551("LootTableSeed");
    }

    @Override
    public void setLootTable(@Nullable class_5321<class_52> resourceKey) {
        this.lootTable = resourceKey;
    }

    @Override
    @Nullable
    public class_5321<class_52> getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTableSeed(long l) {
        this.lootTableSeed = l;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public static class Config {
        public String name = "Container";
        public String titlePrefix = "";
        public int size = 9;
        public boolean purge = false;
        public String openAnimation = null;
        public String closeAnimation = null;
        public boolean canPickup = false;
        public boolean hopperDropperSupport = true;
        public boolean showCustomName = true;
        public boolean angerPiglins = true;
    }
}

