/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.block;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.BehaviourMap;
import de.tomalbrc.filament.data.AbstractBlockData;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.item.FilamentItem;
import de.tomalbrc.filament.item.FilamentItemDelegate;
import de.tomalbrc.filament.util.BlockUtil;
import de.tomalbrc.filament.util.Json;
import de.tomalbrc.filament.util.Util;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5151;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9280;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleBlockItem
extends class_1747
implements PolymerItem,
FilamentItem,
BehaviourHolder,
class_5151 {
    private final AbstractBlockData<?> data;
    protected final BehaviourMap behaviours = new BehaviourMap();
    protected final FilamentItemDelegate delegate;
    protected Object2ObjectOpenHashMap<String, PolymerModelData> modelData;

    public SimpleBlockItem(class_1792.class_1793 properties, class_2248 block, AbstractBlockData<?> data) {
        super(block, properties);
        this.data = data;
        this.initBehaviours(data.behaviour());
        this.delegate = new FilamentItemDelegate(this);
    }

    @NotNull
    public class_2561 method_7864(class_1799 itemStack) {
        class_2561 dataName = this.data.displayName();
        return dataName != null ? dataName : (class_2561)this.data.components().method_57830(class_9334.field_50239, (Object)super.method_7864(itemStack));
    }

    @Override
    public Data<?> getData() {
        return this.data;
    }

    @Override
    public FilamentItemDelegate getDelegate() {
        return this.delegate;
    }

    protected boolean method_7708(class_1750 context, class_2680 state) {
        if (!super.method_7708(context, state)) {
            return false;
        }
        class_1657 class_16572 = context.method_8036();
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            BlockUtil.handleBlockPlaceEffects(player, context.method_20287(), context.method_8037(), state.method_26231());
        }
        return true;
    }

    @Override
    public BehaviourMap getBehaviours() {
        return this.behaviours;
    }

    @Override
    public void method_7860(class_1799 itemStack) {
        if (this.getData() != null) {
            for (Map.Entry<class_9331<?>, JsonElement> entry : this.getData().getAdditionalComponents().entrySet()) {
                Codec codec = entry.getKey().method_57875();
                assert (codec != null);
                class_6903.class_7863 registryInfoLookup = Json.DataComponentsDeserializer.createContext((class_5455)Filament.REGISTRY_ACCESS.method_45926());
                DataResult result = codec.decode((DynamicOps)class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)registryInfoLookup), (Object)entry.getValue());
                if (!result.hasResultOrPartial()) continue;
                class_9331<?> type = entry.getKey();
                itemStack.method_57379(type, ((Pair)result.getOrThrow()).getFirst());
            }
        }
    }

    @Override
    public void requestModels() {
        this.modelData = this.data.requestModels();
    }

    @Override
    public Map<String, PolymerModelData> getModelData() {
        return this.modelData;
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 itemStack, int i) {
        this.delegate.onUseTick(level, livingEntity, itemStack, i);
    }

    public void method_7840(class_1799 itemStack, class_1937 level, class_1309 livingEntity, int useDuration) {
        this.delegate.releaseUsing(itemStack, level, livingEntity, useDuration);
    }

    public boolean method_7838(class_1799 itemStack) {
        return this.delegate.useOnRelease(itemStack, () -> super.method_7838(itemStack));
    }

    public int method_7881(class_1799 itemStack, class_1309 livingEntity) {
        return this.delegate.getUseDuration(itemStack, livingEntity, () -> super.method_7881(itemStack, livingEntity));
    }

    public void method_59978(class_1799 itemStack, class_1309 livingEntity, class_1309 livingEntity2) {
        this.delegate.postHurtEnemy(itemStack, livingEntity, livingEntity2);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> list, class_1836 tooltipFlag) {
        this.delegate.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        this.data.properties().appendHoverText(list::add);
        super.method_7851(itemStack, tooltipContext, list, tooltipFlag);
    }

    public class_1792 getPolymerItem(class_1799 itemStack, class_3222 packetContext) {
        return this.getData().vanillaItem();
    }

    public final class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, class_7225.class_7874 lookup, class_3222 packetContext) {
        return Util.filamentItemStack(itemStack, tooltipType, lookup, packetContext, this);
    }

    public int getPolymerCustomModelData(class_1799 itemStack, @Nullable class_3222 player) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            int data;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof ItemBehaviour) || (data = (itemBehaviour = (ItemBehaviour)behaviour2).modifyPolymerCustomModelData((Map<String, PolymerModelData>)this.modelData, itemStack, player)) == -1) continue;
            return data;
        }
        return this.modelData != null && !this.modelData.isEmpty() ? ((PolymerModelData)this.modelData.getOrDefault((Object)"default", (Object)((PolymerModelData)this.modelData.values().iterator().next()))).value() : (this.data.components().method_57832(class_9334.field_49628) ? Objects.requireNonNull((class_9280)this.data.components().method_57829(class_9334.field_49637)).comp_2382() : -1);
    }

    public int getPolymerArmorColor(class_1799 itemStack, @Nullable class_3222 player) {
        int color = -1;
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof ItemBehaviour)) continue;
            ItemBehaviour itemBehaviour = (ItemBehaviour)behaviour2;
            color = itemBehaviour.modifyPolymerArmorColor(itemStack, player, color);
        }
        return color;
    }

    public boolean method_7878(class_1799 itemStack, class_1799 itemStack2) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            boolean valid;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof ItemBehaviour) || !(valid = (itemBehaviour = (ItemBehaviour)behaviour2).isValidRepairItem(itemStack, itemStack2))) continue;
            return true;
        }
        return super.method_7878(itemStack, itemStack2);
    }

    @NotNull
    public class_6880<class_3414> method_31570() {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            class_6880<class_3414> sound;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof ItemBehaviour) || (sound = (itemBehaviour = (ItemBehaviour)behaviour2).getEquipSound()) == null) continue;
            return sound;
        }
        return FilamentItem.super.method_31570();
    }

    public int method_7837() {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            Optional<Integer> val;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof ItemBehaviour) || !(val = (itemBehaviour = (ItemBehaviour)behaviour2).getEnchantmentValue()).isPresent()) continue;
            return val.get();
        }
        return super.method_7837();
    }

    @NotNull
    public class_1304 method_7685() {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            class_1304 slot;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof ItemBehaviour) || (slot = (itemBehaviour = (ItemBehaviour)behaviour2).getEquipmentSlot()) == class_1304.field_6173) continue;
            return slot;
        }
        return class_1304.field_6173;
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 user, class_1268 hand) {
        return this.delegate.use((class_1792)this, level, user, hand, () -> super.method_7836(level, user, hand));
    }

    @NotNull
    public class_1269 method_7884(class_1838 useOnContext) {
        return this.delegate.useOn(useOnContext, () -> {
            class_1269 res = super.method_7884(useOnContext);
            if (res.method_23665()) {
                return res;
            }
            return class_1269.field_5814;
        });
    }

    public boolean method_7879(class_1799 itemStack, class_1937 level, class_2680 blockState, class_2338 blockPos, class_1309 livingEntity) {
        return this.delegate.mineBlock(itemStack, level, blockState, blockPos, livingEntity, () -> super.method_7879(itemStack, level, blockState, blockPos, livingEntity));
    }

    public float method_58403(class_1297 entity, float f, class_1282 damageSource) {
        return this.delegate.getAttackDamageBonus(entity, f, damageSource, () -> Float.valueOf(super.method_58403(entity, f, damageSource)));
    }
}

