/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.holder;

import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.decoration.block.ComplexDecorationBlock;
import de.tomalbrc.filament.decoration.holder.FilamentDecorationHolder;
import de.tomalbrc.filament.decoration.util.DecorationItemDisplayElement;
import de.tomalbrc.filament.decoration.util.ItemFrameElement;
import de.tomalbrc.filament.util.DecorationUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_3738;
import org.jetbrains.annotations.Nullable;

public class DecorationHolder
extends ElementHolder
implements FilamentDecorationHolder {
    private final Supplier<class_1799> pickResult;

    public DecorationHolder(Supplier<class_1799> pickResult) {
        this.pickResult = pickResult;
    }

    protected void onAttachmentSet(HolderAttachment attachment, @Nullable HolderAttachment oldAttachment) {
        BlockBoundAttachment blockAttachment;
        if (attachment instanceof BlockBoundAttachment && (blockAttachment = (BlockBoundAttachment)attachment).getBlockState().method_26204() instanceof ComplexDecorationBlock) {
            Filament.SERVER.method_18858((Runnable)new class_3738(0, () -> blockAttachment.setBlockState(blockAttachment.getBlockState())));
        }
    }

    @Override
    public void updateVisualItem(class_1799 newItem) {
        for (VirtualElement element : this.getElements()) {
            if (!(element instanceof DecorationItemDisplayElement)) continue;
            DecorationItemDisplayElement itemDisplayElement = (DecorationItemDisplayElement)element;
            itemDisplayElement.setItem(newItem);
        }
        this.tick();
    }

    @Override
    public void playAnimation(String animation, int priority, Runnable onFinish) {
        if (onFinish != null) {
            onFinish.run();
        }
    }

    @Override
    public <T extends VirtualElement> T addElement(T element) {
        VirtualElement res = super.addElement(element);
        if (element instanceof InteractionElement) {
            InteractionElement interactionElement = (InteractionElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.put(interactionElement.getEntityId(), this::getPickResult);
        }
        if (element instanceof ItemFrameElement) {
            ItemFrameElement itemFrameElement = (ItemFrameElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.put(itemFrameElement.getEntityId(), this::getPickResult);
        }
        return (T)res;
    }

    protected void onAttachmentRemoved(HolderAttachment oldAttachment) {
        for (VirtualElement element : this.getElements()) {
            Object interactionElement;
            if (element instanceof InteractionElement) {
                interactionElement = (InteractionElement)element;
                DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.remove(interactionElement.getEntityId());
            }
            if (!(element instanceof ItemFrameElement)) continue;
            interactionElement = (ItemFrameElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.remove(interactionElement.getEntityId());
        }
        super.onAttachmentRemoved(oldAttachment);
    }

    public void notifyUpdate(HolderAttachment.UpdateType updateType) {
        super.notifyUpdate(updateType);
        if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE && this.getAttachment() != null) {
            this.update(((BlockAwareAttachment)this.getAttachment()).getBlockState());
        }
    }

    @Override
    public boolean isAnimated() {
        return false;
    }

    @Override
    public class_1799 getPickResult() {
        return this.pickResult.get();
    }
}

