/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.util.Json;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class ItemAssetGenerator {
    public static void createBow(ResourcePackBuilder builder, class_2960 id, ItemResource itemResource, boolean dye) {
        class_2960 defaultModel = itemResource.getModels().get("default");
        class_2960 pulling_0 = itemResource.getModels().get("pulling_0");
        class_2960 pulling_1 = itemResource.getModels().get("pulling_1");
        class_2960 pulling_2 = itemResource.getModels().get("pulling_2");
        JsonObject bowModel = new JsonObject();
        bowModel.addProperty("parent", defaultModel.toString());
        JsonArray overrides = new JsonArray();
        overrides.add((JsonElement)ItemAssetGenerator.createOverride(1, pulling_0.toString(), null));
        overrides.add((JsonElement)ItemAssetGenerator.createOverride(1, pulling_1.toString(), 0.65));
        overrides.add((JsonElement)ItemAssetGenerator.createOverride(1, pulling_2.toString(), 0.9));
        bowModel.add("overrides", (JsonElement)overrides);
        builder.addData(AssetPaths.itemModel((class_2960)id), bowModel.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void createCrossbow(ResourcePackBuilder builder, class_2960 id, ItemResource itemResource, boolean dye) {
        class_2960 defaultModel = itemResource.getModels().get("default");
        class_2960 rocket = itemResource.getModels().get("rocket");
        class_2960 arrow = itemResource.getModels().get("arrow");
        class_2960 pulling_0 = itemResource.getModels().get("pulling_0");
        class_2960 pulling_1 = itemResource.getModels().get("pulling_1");
        class_2960 pulling_2 = itemResource.getModels().get("pulling_2");
        JsonObject crossbowModel = new JsonObject();
        crossbowModel.addProperty("parent", defaultModel.toString());
        JsonArray overrides = new JsonArray();
        overrides.add((JsonElement)ItemAssetGenerator.createOverride(1, pulling_0.toString(), null));
        overrides.add((JsonElement)ItemAssetGenerator.createOverride(1, pulling_1.toString(), 0.58));
        overrides.add((JsonElement)ItemAssetGenerator.createOverride(1, pulling_2.toString(), 1.0));
        overrides.add((JsonElement)ItemAssetGenerator.createOverride("charged", rocket.toString(), 1));
        overrides.add((JsonElement)ItemAssetGenerator.createOverride("charged", arrow.toString(), 1));
        crossbowModel.add("overrides", (JsonElement)overrides);
        builder.addData(AssetPaths.itemModel((class_2960)id), crossbowModel.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void createShield(ResourcePackBuilder builder, class_2960 id, ItemResource itemResource) {
        class_2960 defaultModel = itemResource.getModels().get("default");
        class_2960 blocking = itemResource.getModels().get("blocking");
        JsonObject shieldModel = new JsonObject();
        shieldModel.addProperty("parent", defaultModel.toString());
        JsonArray overrides = new JsonArray();
        overrides.add((JsonElement)ItemAssetGenerator.createOverride("blocking", blocking.toString(), 1));
        shieldModel.add("overrides", (JsonElement)overrides);
        builder.addData(AssetPaths.itemModel((class_2960)id), shieldModel.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void createFishingRod(ResourcePackBuilder builder, class_2960 id, ItemResource itemResource, boolean dye) {
        class_2960 defaultModel = itemResource.getModels().get("default");
        class_2960 cast = itemResource.getModels().get("cast");
        JsonObject rodModel = new JsonObject();
        rodModel.addProperty("parent", defaultModel.toString());
        JsonArray overrides = new JsonArray();
        overrides.add((JsonElement)ItemAssetGenerator.createOverride("cast", cast.toString(), 1));
        rodModel.add("overrides", (JsonElement)overrides);
        builder.addData(AssetPaths.itemModel((class_2960)id), rodModel.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static JsonObject createOverride(int pulling, String model, Double pull) {
        JsonObject predicate = new JsonObject();
        predicate.addProperty("pulling", (Number)pulling);
        if (pull != null) {
            predicate.addProperty("pull", (Number)pull);
        }
        JsonObject override = new JsonObject();
        override.add("predicate", (JsonElement)predicate);
        override.addProperty("model", model);
        return override;
    }

    private static JsonObject createOverride(String predicateKey, String model, int value) {
        JsonObject predicate = new JsonObject();
        predicate.addProperty(predicateKey, (Number)value);
        JsonObject override = new JsonObject();
        override.add("predicate", (JsonElement)predicate);
        override.addProperty("model", model);
        return override;
    }

    public static void createItemModels(class_2960 id, ItemResource itemResource) {
        if (itemResource.couldGenerate()) {
            for (Map.Entry<String, Map<String, class_2960>> entry : itemResource.textures().entrySet()) {
                class_2960 modelId = id.method_45138("item/").method_48331("_" + entry.getKey());
                PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(builder -> {
                    JsonObject object = new JsonObject();
                    object.add("parent", (JsonElement)new JsonPrimitive(itemResource.parent().method_12836().equals("minecraft") ? itemResource.parent().method_12832() : itemResource.parent().toString()));
                    JsonObject textures = new JsonObject();
                    for (Map.Entry texturesMapEntry : ((Map)entry.getValue()).entrySet()) {
                        textures.add((String)texturesMapEntry.getKey(), (JsonElement)new JsonPrimitive(((class_2960)texturesMapEntry.getValue()).method_12836().equals("minecraft") ? ((class_2960)texturesMapEntry.getValue()).method_12832() : ((class_2960)texturesMapEntry.getValue()).toString()));
                    }
                    object.add("textures", (JsonElement)textures);
                    builder.addData("assets/" + modelId.method_12836() + "/models/" + modelId.method_12832() + ".json", Json.GSON.toJson((JsonElement)object).getBytes(StandardCharsets.UTF_8));
                });
                itemResource.getModels().put(entry.getKey(), modelId);
            }
        }
    }

    public static void createTrident(ResourcePackBuilder resourcePackBuilder, @NotNull class_2960 id, ItemResource itemResource, boolean b) {
    }
}

