/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import de.tomalbrc.filament.util.Json;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.class_2960;

public class Templates {
    private static final Map<class_2960, JsonObject> TEMPLATES = new Object2ObjectOpenHashMap();

    public static void add(InputStream inputStream) throws Exception {
        JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(Json.camelToSnakeCase(inputStream)));
        if (element != null && element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            TEMPLATES.put(class_2960.method_60654((String)object.getAsJsonPrimitive("id").getAsString()), object);
        }
    }

    public static JsonElement handlePlaceholder(JsonElement element, class_2960 id) {
        if (element.isJsonObject()) {
            JsonObject obj = new JsonObject();
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                obj.add((String)entry.getKey(), Templates.handlePlaceholder((JsonElement)entry.getValue(), id));
            }
            return obj;
        }
        if (element.isJsonArray()) {
            JsonArray arr = new JsonArray();
            for (JsonElement v : element.getAsJsonArray()) {
                arr.add(Templates.handlePlaceholder(v, id));
            }
            return arr;
        }
        if (element.isJsonPrimitive()) {
            String value;
            JsonPrimitive prim = element.getAsJsonPrimitive();
            if (prim.isString() && ((value = prim.getAsString()).contains("<item_id_capitalized>") || value.contains("<item_id>"))) {
                String replaced = value.replace("<item_id_capitalized>", Templates.capitalizeWords(id.method_12832())).replace("<item_namespace>", id.method_12836()).replace("<item_id>", id.method_12832());
                return new JsonPrimitive(replaced);
            }
            return prim.deepCopy();
        }
        return element.deepCopy();
    }

    public static String capitalizeWords(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        for (String word : input.replace("_", " ").split(" ")) {
            if (word.isEmpty()) continue;
            sb.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() > 1) {
                sb.append(word.substring(1).toLowerCase());
            }
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public static JsonObject merge(class_2960 templateId, class_2960 contentId, JsonObject json2) {
        JsonObject template = TEMPLATES.get(templateId);
        if (template == null) {
            throw new IllegalArgumentException(String.format("Template id '%s' not found for '%s'!", templateId, contentId));
        }
        JsonObject result = template.deepCopy();
        for (Map.Entry e : json2.entrySet()) {
            String key = (String)e.getKey();
            JsonElement value2 = ((JsonElement)e.getValue()).deepCopy();
            if (result.has(key) && result.get(key).isJsonObject() && value2.isJsonObject()) {
                JsonObject merged = Templates.mergeJsonObject(result.getAsJsonObject(key), value2.getAsJsonObject());
                result.add(key, (JsonElement)merged);
                continue;
            }
            result.add(key, value2);
        }
        return result;
    }

    private static JsonObject mergeJsonObject(JsonObject obj1, JsonObject obj2) {
        JsonObject merged = obj1.deepCopy();
        for (Map.Entry e : obj2.entrySet()) {
            String key = (String)e.getKey();
            JsonElement value2 = ((JsonElement)e.getValue()).deepCopy();
            if (merged.has(key)) {
                JsonElement value1 = merged.get(key);
                if (value1.isJsonObject() && value2.isJsonObject()) {
                    JsonObject childMerged = Templates.mergeJsonObject(value1.getAsJsonObject(), value2.getAsJsonObject());
                    merged.add(key, (JsonElement)childMerged);
                    continue;
                }
                merged.add(key, value2);
                continue;
            }
            merged.add(key, value2);
        }
        return merged;
    }
}

