/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.data.EntityData;
import de.tomalbrc.filament.util.Json;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import org.apache.commons.lang3.tuple.Triple;

public class Translations {
    private static final Map<String, Map<Triple<class_1792, class_2248, class_1299<?>>, String>> translations = new Object2ObjectArrayMap();

    public static void add(class_1299<?> entity, EntityData data) {
        if (data.translations() != null) {
            for (Map.Entry<String, String> entry : Objects.requireNonNull(data.translations()).entrySet()) {
                Translations.add(entry.getKey(), Triple.of(null, null, entity), entry.getValue());
            }
        }
    }

    public static void add(class_1792 item, class_2248 block, Data<?> data) {
        if (data.translations() != null) {
            for (Map.Entry<String, String> entry : Objects.requireNonNull(data.translations()).entrySet()) {
                Translations.add(entry.getKey(), Triple.of((Object)item, (Object)block, null), entry.getValue());
            }
        }
    }

    private static void add(String locale, Triple<class_1792, class_2248, class_1299<?>> translationId, String text) {
        translations.putIfAbsent(locale, (Map<Triple<class_1792, class_2248, class_1299<?>>, String>)new Object2ObjectArrayMap());
        translations.get(locale).put(translationId, text);
    }

    public static void registerEventHandler() {
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> {
            for (Map.Entry<String, Map<Triple<class_1792, class_2248, class_1299<?>>, String>> entry : translations.entrySet()) {
                JsonObject object = new JsonObject();
                for (Map.Entry<Triple<class_1792, class_2248, class_1299<?>>, String> idTextEntry : entry.getValue().entrySet()) {
                    Triple<class_1792, class_2248, class_1299<?>> pair = idTextEntry.getKey();
                    if (pair.getLeft() != null) {
                        object.add(((class_1792)pair.getLeft()).method_7876(), (JsonElement)new JsonPrimitive(idTextEntry.getValue()));
                    }
                    if (pair.getMiddle() != null) {
                        object.add(((class_2248)pair.getMiddle()).method_9539(), (JsonElement)new JsonPrimitive(idTextEntry.getValue()));
                    }
                    if (pair.getRight() == null) continue;
                    object.add(((class_1299)pair.getRight()).method_5882(), (JsonElement)new JsonPrimitive(idTextEntry.getValue()));
                }
                String str = Json.GSON.toJson((JsonElement)object);
                resourcePackBuilder.addData("assets/filament/lang/" + entry.getKey() + ".json", str.getBytes(StandardCharsets.UTF_8));
            }
        });
    }
}

