/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament;

import com.mojang.logging.LogUtils;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.block.Fire;
import de.tomalbrc.filament.command.FilamentCommand;
import de.tomalbrc.filament.data.ItemGroupData;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.registry.BiomeModifications;
import de.tomalbrc.filament.registry.BlockRegistry;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.registry.EntityRegistry;
import de.tomalbrc.filament.registry.FilamentComponents;
import de.tomalbrc.filament.registry.ItemGroupRegistry;
import de.tomalbrc.filament.registry.ItemRegistry;
import de.tomalbrc.filament.registry.ModelRegistry;
import de.tomalbrc.filament.util.AsyncBlockTicker;
import de.tomalbrc.filament.util.Constants;
import de.tomalbrc.filament.util.FilamentAssetReloadListener;
import de.tomalbrc.filament.util.FilamentConfig;
import de.tomalbrc.filament.util.FilamentReloadUtil;
import de.tomalbrc.filament.util.FilamentTemplateReloadListener;
import de.tomalbrc.filament.util.SkinUtil;
import de.tomalbrc.filament.util.TextUtil;
import de.tomalbrc.filament.util.Translations;
import de.tomalbrc.filament.util.VirtualDestroyStage;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public class Filament
implements ModInitializer {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static class_7780<class_7659> REGISTRY_ACCESS;
    public static MinecraftServer SERVER;
    public static MinecraftServerAudiences ADVENTURE;

    public static MinecraftServerAudiences adventure() {
        if (ADVENTURE == null) {
            throw new IllegalStateException("Tried to access Adventure without a running server!");
        }
        return ADVENTURE;
    }

    public void onInitialize() {
        if (FilamentConfig.getInstance().addCustomMenuAssets) {
            PolymerResourcePackUtils.addModAssets((String)"filament");
        }
        PolymerResourcePackUtils.markAsRequired();
        FilamentComponents.register();
        Behaviours.register();
        SkinUtil.registerEventHandler();
        Translations.registerEventHandler();
        EntityRegistry.register();
        Filament.nexoHint();
        if (FilamentConfig.getInstance().commands) {
            FilamentCommand.register();
        }
        VirtualDestroyStage.init();
        AsyncBlockTicker.init();
        Fire.addRemap();
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(Fire::init);
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2586 patt0$temp;
            class_2338 pos;
            class_2680 blockState;
            if (!world.method_8608() && hand == class_1268.field_5808 && DecorationRegistry.isDecoration(blockState = world.method_8320(pos = hitResult.method_17777())) && (patt0$temp = world.method_8321(pos)) instanceof DecorationBlockEntity) {
                DecorationBlockEntity decorationBlockEntity = (DecorationBlockEntity)patt0$temp;
                return decorationBlockEntity.decorationInteract((class_3222)player, hand, hitResult.method_17784());
            }
            return class_1269.field_5811;
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ADVENTURE = MinecraftServerAudiences.of((MinecraftServer)server);
            SERVER = server;
        });
        ServerTickEvents.END_SERVER_TICK.register(AsyncBlockTicker::tick);
        ServerChunkEvents.CHUNK_UNLOAD.register(AsyncBlockTicker::remove);
        ServerLifecycleEvents.SERVER_STOPPING.register(minecraftServer -> ADVENTURE.close());
        ItemGroupRegistry.register(new ItemGroupData(Constants.ITEM_GROUP_ID, class_2960.method_60656((String)"diamond"), TextUtil.formatText("<c:blue>Filament Items")));
        ItemGroupRegistry.register(new ItemGroupData(Constants.BLOCK_GROUP_ID, class_2960.method_60656((String)"furnace"), TextUtil.formatText("<c:blue>Filament Blocks")));
        ItemGroupRegistry.register(new ItemGroupData(Constants.DECORATION_GROUP_ID, class_2960.method_60656((String)"lantern"), TextUtil.formatText("<c:blue>Filament Decorations")));
        FilamentReloadUtil.registerEarlyReloadListener(new FilamentAssetReloadListener());
        FilamentReloadUtil.registerEarlyReloadListener(new FilamentTemplateReloadListener());
        FilamentReloadUtil.registerEarlyReloadListener(new ModelRegistry.AjModelReloadListener());
        FilamentReloadUtil.registerEarlyReloadListener(new ItemRegistry.ItemDataReloadListener());
        FilamentReloadUtil.registerEarlyReloadListener(new BlockRegistry.BlockDataReloadListener());
        FilamentReloadUtil.registerEarlyReloadListener(new DecorationRegistry.DecorationDataReloadListener());
        if (FilamentConfig.getInstance().entityModule) {
            FilamentReloadUtil.registerEarlyReloadListener(new EntityRegistry.EntityDataReloadListener());
        }
        FilamentReloadUtil.registerEarlyReloadListener(new ItemGroupRegistry.ItemGroupDataReloadListener());
        FilamentReloadUtil.registerEarlyReloadListener(new BiomeModifications.BiomeModificationsDataReloadListener());
        if (FilamentConfig.getInstance().debug) {
            LOGGER.info("Available Polymer block model types:");
            this.logModelTypes();
            ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
                LOGGER.info("Available Polymer block model types after server start:");
                this.logModelTypes();
            });
        }
    }

    private static void nexoHint() {
        Path nexoDir = FabricLoader.getInstance().getGameDir().resolve("nexo");
        File nexoDirFile = nexoDir.toFile();
        if (!FabricLoader.getInstance().isModLoaded("filament-nexo") && nexoDirFile.exists() && nexoDirFile.isDirectory() && nexoDirFile.listFiles() != null && Arrays.stream(Objects.requireNonNull(nexoDirFile.listFiles())).anyMatch(x -> !FilenameUtils.getBaseName((String)x.getPath()).startsWith("."))) {
            throw new RuntimeException("Found nexo folder with packs, please install filament-nexo (https://modrinth.com/mod/filament-nexo) or remove the nexo directory in your game directory!");
        }
    }

    private void logModelTypes() {
        for (BlockModelType blockModelType : BlockModelType.values()) {
            LOGGER.info("\t{} = {}", (Object)blockModelType.name(), (Object)PolymerBlockResourceUtils.getBlocksLeft((BlockModelType)blockModelType));
        }
    }
}

