/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class CanSurvive
implements BlockBehaviour<Config> {
    private final Config config;

    public CanSurvive(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean canSurvive(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        class_2350.class_2351 axis = this.getAxisOrNull(blockState);
        if (axis != null) {
            return this.test(axis, blockPos, levelReader, blockState);
        }
        class_2350 direction = this.getFacing(blockState);
        return this.test(direction, blockPos, levelReader, blockState);
    }

    private boolean test(class_2350 direction, class_2338 blockPos, class_4538 levelReader, class_2680 blockState) {
        class_2680 belowState = levelReader.method_8320(blockPos.method_10093(direction));
        if (this.config.blocks != null) {
            for (class_2960 resourceLocation : this.config.blocks) {
                class_2248 block = (class_2248)class_7923.field_41175.method_63535(resourceLocation);
                if (!belowState.method_27852(block)) continue;
                return !belowState.method_27852(class_2246.field_10382) || levelReader.method_8316(blockPos.method_10093(direction)).method_15771();
            }
        }
        if (this.config.tags != null) {
            for (class_2960 tag : this.config.tags) {
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tag);
                if (!belowState.method_26164(tagKey)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean test(class_2350.class_2351 axis, class_2338 blockPos, class_4538 levelReader, class_2680 blockState) {
        for (class_2350 direction : axis.method_10180()) {
            if (!this.test(direction, blockPos, levelReader, blockState)) continue;
            return true;
        }
        return false;
    }

    private class_2350.class_2351 getAxisOrNull(class_2680 blockState) {
        ImmutableList props2 = ImmutableList.of((Object)class_2741.field_12496, (Object)class_2741.field_12529);
        for (class_2754 prop : props2) {
            if (!blockState.method_28498((class_2769)prop)) continue;
            return (class_2350.class_2351)blockState.method_11654((class_2769)prop);
        }
        return null;
    }

    private class_2350 getFacing(class_2680 blockState) {
        ImmutableList props = ImmutableList.of((Object)class_2741.field_12525, (Object)class_2741.field_12481, (Object)class_2741.field_28062, (Object)class_2741.field_12545);
        for (class_2754 prop : props) {
            if (!blockState.method_28498((class_2769)prop)) continue;
            return (class_2350)blockState.method_11654((class_2769)prop);
        }
        return class_2350.field_11033;
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        return !blockState.method_26184(levelReader, blockPos) ? class_2246.field_10124.method_9564() : blockState;
    }

    public static class Config {
        public List<class_2960> blocks;
        public List<class_2960> tags;
    }
}

