/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.entity.target;

import de.tomalbrc.filament.api.behaviour.EntityBehaviour;
import de.tomalbrc.filament.entity.FilamentMob;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1928;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4051;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HurtByTargetGoal
implements EntityBehaviour<Config> {
    private final Config config;

    public HurtByTargetGoal(Config config) {
        this.config = config;
    }

    @Override
    public void registerGoals(FilamentMob mob) {
        EntityBehaviour.super.registerGoals(mob);
        int size = this.config.ignoreFrom == null ? 0 : this.config.ignoreFrom.size();
        class_1299[] classes = new class_1299[size];
        for (int i = 0; i < size; ++i) {
            classes[i] = (class_1299)class_7923.field_41177.method_63535(this.config.ignoreFrom.get(i));
        }
        HurtByTargetGoalImpl goal = new HurtByTargetGoalImpl((class_1314)mob, classes);
        if (this.config.alertOthers != null && !this.config.alertOthers.isEmpty()) {
            class_1299[] classes2 = new class_1299[this.config.alertOthers.size()];
            for (int i = 0; i < this.config.alertOthers.size(); ++i) {
                classes2[i] = (class_1299)class_7923.field_41177.method_63535(this.config.alertOthers.get(i));
            }
            goal = goal.setAlertOthers(classes2);
        }
        mob.getTargetSelector().method_6277(this.config.priority, (class_1352)goal);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public static class Config {
        int priority;
        List<class_2960> ignoreFrom;
        List<class_2960> alertOthers;
    }

    public static class HurtByTargetGoalImpl
    extends class_1405 {
        private static final class_4051 HURT_BY_TARGETING = class_4051.method_36625().method_36627().method_18424();
        private static final int ALERT_RANGE_Y = 10;
        private boolean alertSameType;
        private int timestamp;
        private final class_1299<?>[] toIgnoreDamage;
        @Nullable
        private class_1299<?>[] toIgnoreAlert;

        public HurtByTargetGoalImpl(class_1314 pathfinderMob, class_1299<?> ... classs) {
            super((class_1308)pathfinderMob, true);
            this.toIgnoreDamage = classs;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            int i = this.field_6660.method_6117();
            class_1309 livingEntity = this.field_6660.method_6065();
            if (i != this.timestamp && livingEntity != null) {
                if (livingEntity.method_5864() == class_1299.field_6097 && HurtByTargetGoalImpl.method_64451((class_1297)this.field_6660).method_64395().method_8355(class_1928.field_25402)) {
                    return false;
                }
                for (class_1299<?> type : this.toIgnoreDamage) {
                    if (type != livingEntity.method_5864()) continue;
                    return false;
                }
                return this.method_6328(livingEntity, HURT_BY_TARGETING);
            }
            return false;
        }

        public HurtByTargetGoalImpl setAlertOthers(class_1299<?> ... classs) {
            this.alertSameType = true;
            this.toIgnoreAlert = classs;
            return this;
        }

        public void method_6269() {
            this.field_6660.method_5980(this.field_6660.method_6065());
            this.field_6664 = this.field_6660.method_5968();
            this.timestamp = this.field_6660.method_6117();
            this.field_6657 = 300;
            if (this.alertSameType) {
                this.alertOthers();
            }
            super.method_6269();
        }

        protected void alertOthers() {
            double followDistance = this.method_6326();
            class_238 aABB = class_238.method_29968((class_243)this.field_6660.method_73189()).method_1009(followDistance, 10.0, followDistance);
            List list = this.field_6660.method_73183().method_8390(this.field_6660.getClass(), aABB, class_1301.field_6155);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                class_1308 mob = (class_1308)iterator.next();
                if (this.field_6660 == mob || mob.method_5968() != null || this.field_6660 instanceof class_1321 && ((class_1321)this.field_6660).method_35057() != ((class_1321)mob).method_35057() || mob.method_5722((class_1297)this.field_6660.method_6065())) continue;
                if (this.toIgnoreAlert != null) {
                    boolean bl = false;
                    for (class_1299<?> type : this.toIgnoreAlert) {
                        if (mob.method_5864() != type) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                }
                this.alertOther(mob, this.field_6660.method_6065());
            }
            return;
        }

        protected void alertOther(class_1308 mob, class_1309 livingEntity) {
            mob.method_5980(livingEntity);
        }
    }
}

