/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data.properties;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.class_5819;

public class RangedValue {
    private final double min;
    private final double max;
    public static final Codec<RangedValue> CODEC = Codec.either((Codec)Codec.DOUBLE, (Codec)Codec.STRING).flatXmap(either -> {
        try {
            if (either.left().isPresent()) {
                double value = (Double)either.left().get();
                return DataResult.success((Object)new RangedValue(value, value));
            }
            return DataResult.success((Object)new RangedValue((String)either.right().get()));
        }
        catch (Exception ex) {
            return DataResult.error(() -> "Invalid RangedValue: " + ex.getMessage());
        }
    }, ranged -> {
        if (ranged.isFixed()) {
            return DataResult.success((Object)Either.left((Object)ranged.getMin()));
        }
        return DataResult.success((Object)Either.right((Object)(ranged.getMin() + ".." + ranged.getMax())));
    });

    public RangedValue(String input) {
        if (input.contains("..")) {
            double max;
            String[] parts = input.split("\\.\\.");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid range: " + input);
            }
            double min = Double.parseDouble(parts[0]);
            if (min > (max = Double.parseDouble(parts[1]))) {
                this.min = max;
                this.max = min;
            } else {
                this.min = min;
                this.max = max;
            }
        } else {
            double value;
            this.min = value = Double.parseDouble(input);
            this.max = value;
        }
    }

    public RangedValue(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("min must be <= max");
        }
        this.min = min;
        this.max = max;
    }

    public RangedValue(double fixed) {
        this.min = fixed;
        this.max = fixed;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double randomValue(class_5819 randomSource) {
        return this.isFixed() ? this.min : this.min + randomSource.method_43058() * (this.max - this.min);
    }

    public boolean isFixed() {
        return this.min == this.max;
    }

    public boolean isInRange(double value) {
        return this.isFixed() ? value == this.min : value >= this.min && value <= this.max;
    }
}

