/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.registry.Templates;
import de.tomalbrc.filament.util.Json;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FilamentSynchronousResourceReloadListener
extends SimpleSynchronousResourceReloadListener {
    default public void loadJson(@NotNull String root, @Nullable String endsWith, @NotNull class_3300 resourceManager, @NotNull BiConsumer<class_2960, InputStream> onRead) {
        Map resources = resourceManager.method_14488(root, path -> path.method_12832().endsWith((endsWith == null ? "" : endsWith) + ".json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                try {
                    ByteArrayInputStream stream;
                    Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
                    if (json.isJsonObject()) {
                        Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
                        Map<String, Object> document = (Map<String, Object>)gson.fromJson(json, mapType);
                        if (document != null) {
                            document = Json.camelToSnakeCase(document);
                        }
                        stream = new ByteArrayInputStream(gson.toJson(document).getBytes(StandardCharsets.UTF_8));
                    } else {
                        stream = new ByteArrayInputStream(gson.toJson(json).getBytes(StandardCharsets.UTF_8));
                    }
                    onRead.accept((class_2960)entry.getKey(), stream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | IllegalStateException e) {
                FilamentSynchronousResourceReloadListener.error((class_2960)entry.getKey(), e);
            }
        }
    }

    default public void loadYaml(@NotNull String root, @Nullable String endsWith, @NotNull class_3300 resourceManager, @NotNull BiConsumer<class_2960, InputStream> onRead) {
        Map resources = resourceManager.method_14488(root, path -> path.method_12832().endsWith((endsWith == null ? "" : endsWith) + ".yaml") || path.method_12832().endsWith((endsWith == null ? "" : endsWith) + ".yml"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                try {
                    List<InputStream> list = Json.yamlToJson(inputStream);
                    for (InputStream stream : list) {
                        onRead.accept((class_2960)entry.getKey(), stream);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | IllegalStateException e) {
                FilamentSynchronousResourceReloadListener.error((class_2960)entry.getKey(), e);
            }
        }
    }

    default public void load(@NotNull String root, @Nullable String endsWith, @NotNull class_3300 resourceManager, @NotNull BiConsumer<class_2960, InputStream> onRead) {
        this.loadYaml(root, endsWith, resourceManager, (id, input) -> {
            if (!FilamentSynchronousResourceReloadListener.loadAsTemplate(input)) {
                onRead.accept((class_2960)id, FilamentSynchronousResourceReloadListener.template(input));
            }
        });
        this.loadJson(root, endsWith, resourceManager, (id, input) -> {
            if (!FilamentSynchronousResourceReloadListener.loadAsTemplate(input)) {
                onRead.accept((class_2960)id, FilamentSynchronousResourceReloadListener.template(input));
            }
        });
    }

    public static boolean loadAsTemplate(InputStream input) {
        JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(input));
        if (element != null && element.isJsonObject()) {
            try {
                if (element.getAsJsonObject().has("is_template") && element.getAsJsonObject().getAsJsonPrimitive("is_template").getAsBoolean()) {
                    Templates.add(input);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void error(class_2960 resourceLocation, Exception e) {
        Filament.LOGGER.error("Failed to load resource \"{}\".", (Object)resourceLocation, (Object)e);
    }

    public static InputStream template(InputStream inputStream) {
        JsonElement parsed = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
        try {
            inputStream.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!parsed.isJsonObject() || !parsed.getAsJsonObject().has("id")) {
            return inputStream;
        }
        JsonObject parsedObject = parsed.getAsJsonObject();
        class_2960 realId = class_2960.method_60654((String)parsedObject.getAsJsonPrimitive("id").getAsString());
        boolean multiTemp = parsedObject.has("templates");
        boolean singleTemp = parsedObject.has("template");
        if (multiTemp || singleTemp) {
            ArrayList<class_2960> templates = new ArrayList<class_2960>();
            if (multiTemp) {
                templateEl = parsedObject.get("templates");
                if (templateEl.isJsonArray()) {
                    JsonArray array = templateEl.getAsJsonArray();
                    for (JsonElement element : array) {
                        if (!element.isJsonPrimitive()) continue;
                        templates.add(class_2960.method_60654((String)element.getAsJsonPrimitive().getAsString()));
                    }
                }
            } else {
                templateEl = parsedObject.get("template");
                if (templateEl.isJsonPrimitive()) {
                    templates.add(class_2960.method_60654((String)templateEl.getAsString()));
                }
            }
            for (class_2960 template : templates) {
                parsed = Templates.merge(template, realId, parsed.getAsJsonObject());
            }
            parsed.getAsJsonObject().remove("is_template");
            JsonElement res = Templates.handlePlaceholder(parsed, realId);
            String jsonString = new Gson().toJson(res);
            return new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));
        }
        return inputStream;
    }
}

