/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.api.event;

import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.block.SimpleBlockItem;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.data.EntityData;
import de.tomalbrc.filament.data.ItemData;
import de.tomalbrc.filament.decoration.DecorationItem;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.item.SimpleItem;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1299;

public class FilamentRegistrationEvents {
    public static final Event<ItemRegistration> ITEM = EventFactory.createArrayBacked(ItemRegistration.class, callbacks -> (data, item) -> {
        for (ItemRegistration callback : callbacks) {
            callback.registered(data, item);
        }
    });
    public static final Event<BlockRegistration> BLOCK = EventFactory.createArrayBacked(BlockRegistration.class, callbacks -> (data, item, block) -> {
        for (BlockRegistration callback : callbacks) {
            callback.registered(data, item, block);
        }
    });
    public static final Event<DecorationRegistration> DECORATION = EventFactory.createArrayBacked(DecorationRegistration.class, callbacks -> (data, item, block) -> {
        for (DecorationRegistration callback : callbacks) {
            callback.registered(data, item, block);
        }
    });
    public static final Event<EntityRegistration> ENTITY = EventFactory.createArrayBacked(EntityRegistration.class, callbacks -> (data, entityType) -> {
        for (EntityRegistration callback : callbacks) {
            callback.registered(data, entityType);
        }
    });

    @FunctionalInterface
    public static interface EntityRegistration {
        public void registered(EntityData var1, class_1299<?> var2);
    }

    @FunctionalInterface
    public static interface DecorationRegistration {
        public void registered(DecorationData var1, DecorationItem var2, DecorationBlock var3);
    }

    @FunctionalInterface
    public static interface BlockRegistration {
        public void registered(BlockData var1, SimpleBlockItem var2, SimpleBlock var3);
    }

    @FunctionalInterface
    public static interface ItemRegistration {
        public void registered(ItemData var1, SimpleItem var2);
    }
}

