/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.api.behaviour.DecorationRotationProvider;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Connectable
implements BlockBehaviour<Config>,
DecorationRotationProvider,
DecorationBehaviour<Config> {
    private final Config config;
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
    private class_2248 block;

    public Connectable(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void init(class_1792 item, class_2248 block, BehaviourHolder behaviourHolder) {
        this.block = block;
    }

    @Override
    public class_1799 visualItemStack(DecorationBlockEntity decorationBlockEntity, class_1799 itemStack, class_2680 blockState) {
        itemStack.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(((Shape)((Object)blockState.method_11654(SHAPE))).customModelData()), List.of()));
        return itemStack;
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 dir, class_2338 neighbourPos, class_2680 neighbourState, class_5819 randomSource) {
        class_2350 direction = (class_2350)blockState.method_11654(FACING);
        if (direction.method_10166().method_10179()) {
            Shape newShape = this.getShape(blockState, levelReader, blockPos);
            return (class_2680)blockState.method_11657(SHAPE, (Comparable)((Object)newShape));
        }
        return blockState;
    }

    @Override
    public class_1799 getCloneItemStack(class_1799 itemStack, class_4538 levelReader, class_2338 blockPos, class_2680 blockState, boolean includeData) {
        return DecorationBehaviour.super.getCloneItemStack(itemStack, levelReader, blockPos, blockState, includeData);
    }

    private Shape getShape(class_2680 state, class_4538 level, class_2338 pos) {
        boolean rightConnected;
        class_2350 facing = (class_2350)state.method_11654(FACING);
        class_2350 leftSide = facing.method_10160();
        class_2350 rightSide = facing.method_10170();
        class_2680 leftState = level.method_8320(pos.method_10093(leftSide));
        class_2680 rightState = level.method_8320(pos.method_10093(rightSide));
        boolean leftConnected = this.isSameType(leftState) && (leftState.method_11654(FACING) == facing || leftState.method_11654(FACING) == facing.method_10170() && ((Shape)((Object)leftState.method_11654(Connectable.SHAPE))).cornerOuter || leftState.method_11654(FACING) == facing.method_10160() && ((Shape)((Object)leftState.method_11654(Connectable.SHAPE))).cornerOuter);
        boolean bl = rightConnected = this.isSameType(rightState) && (rightState.method_11654(FACING) == facing || rightState.method_11654(FACING) == facing.method_10170() && ((Shape)((Object)rightState.method_11654(Connectable.SHAPE))).cornerInner || rightState.method_11654(FACING) == facing.method_10160() && ((Shape)((Object)rightState.method_11654(Connectable.SHAPE))).cornerInner);
        if (leftConnected && rightConnected) {
            return Shape.STRAIGHT;
        }
        if (this.config.corners) {
            class_2680 backState;
            class_2680 frontState = level.method_8320(pos.method_10093(facing.method_10153()));
            if (this.isSameType(frontState) && !((Shape)((Object)frontState.method_11654(SHAPE))).isCorner()) {
                boolean isFrontRightCorner;
                class_2350 frontFacing = (class_2350)frontState.method_11654(FACING);
                boolean isFrontLeftCorner = frontFacing == facing.method_10160();
                boolean bl2 = isFrontRightCorner = frontFacing == facing.method_10170();
                if (isFrontLeftCorner && this.canTakeCornerShape(state, level, pos, frontFacing.method_10153())) {
                    return Shape.OUTER_LEFT;
                }
                if (isFrontRightCorner && this.canTakeCornerShape(state, level, pos, frontFacing.method_10153())) {
                    return Shape.OUTER_RIGHT;
                }
            }
            if (this.isSameType(backState = level.method_8320(pos.method_10093(facing))) && !((Shape)((Object)backState.method_11654(SHAPE))).isCorner()) {
                boolean isBackRightCorner;
                class_2350 backFacing = (class_2350)backState.method_11654(FACING);
                boolean isBackLeftCorner = backFacing == facing.method_10160();
                boolean bl3 = isBackRightCorner = backFacing == facing.method_10170();
                if (isBackLeftCorner && this.canTakeCornerShape(state, level, pos, backFacing)) {
                    return Shape.INNER_LEFT;
                }
                if (isBackRightCorner && this.canTakeCornerShape(state, level, pos, backFacing)) {
                    return Shape.INNER_RIGHT;
                }
            }
        }
        if (leftConnected) {
            return Shape.RIGHT;
        }
        if (rightConnected) {
            return Shape.LEFT;
        }
        return Shape.SINGLE;
    }

    private boolean canTakeCornerShape(class_2680 state, class_4538 level, class_2338 pos, class_2350 direction) {
        class_2680 adjacent = level.method_8320(pos.method_10093(direction));
        return this.isSameType(adjacent) && (adjacent.method_11654(FACING) == state.method_11654(FACING) || adjacent.method_11654(FACING) == ((class_2350)state.method_11654(FACING)).method_10160() || adjacent.method_11654(FACING) == ((class_2350)state.method_11654(FACING)).method_10170());
    }

    private boolean isSameType(@Nullable class_2680 state) {
        return state != null && state.method_26204() == this.block;
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 blockState, class_1750 context) {
        blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153());
        return (class_2680)blockState.method_11657(SHAPE, (Comparable)((Object)this.getShape(blockState, (class_4538)context.method_8045(), context.method_8037())));
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHAPE});
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Override
    public float getVisualRotationYInDegrees(class_2680 blockState) {
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
        Shape shape = (Shape)((Object)blockState.method_11654(SHAPE));
        if (!(shape != Shape.INNER_RIGHT && shape != Shape.OUTER_RIGHT || facing.method_10166() != class_2350.class_2351.field_11048 && facing.method_10166() != class_2350.class_2351.field_11051)) {
            return facing.method_10153().method_10144() + 90.0f;
        }
        return facing.method_10153().method_10144();
    }

    @Override
    public class_2680 rotate(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)class_2741.field_12481, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)class_2741.field_12481)));
    }

    @Override
    public class_2680 mirror(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)class_2741.field_12481)));
    }

    public static class Config {
        public boolean corners = true;
    }

    public static enum Shape implements class_3542
    {
        STRAIGHT("middle", "middle", false, false),
        INNER_LEFT("inner_left", "inner", false, true),
        INNER_RIGHT("inner_right", "inner", true, false),
        OUTER_LEFT("outer_left", "outer", false, true),
        OUTER_RIGHT("outer_right", "outer", true, false),
        LEFT("left", "left", false, false),
        RIGHT("right", "right", false, false),
        SINGLE("single", "single", false, false);

        private final String name;
        private final String customModelData;
        private final boolean cornerOuter;
        private final boolean cornerInner;

        private Shape(String name, String customModelData, boolean cornerOuter, boolean cornerInner) {
            this.name = name;
            this.customModelData = customModelData;
            this.cornerOuter = cornerOuter;
            this.cornerInner = cornerInner;
        }

        public String customModelData() {
            return this.customModelData;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public boolean isCorner() {
            return this.cornerInner || this.cornerOuter;
        }
    }
}

