/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.item;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.behaviour.ItemPredicateModelProvider;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.generator.ItemAssetGenerator;
import de.tomalbrc.filament.mixin.accessor.ProjectileWeaponItemInvoker;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class Bow
implements ItemBehaviour<Config>,
ItemPredicateModelProvider {
    private final Config config;

    public Bow(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    protected void shoot(class_3218 serverLevel, class_1309 livingEntity, class_1268 interactionHand, class_1799 itemStack, List<class_1799> list, float f, boolean fullPower) {
        float spread = class_1890.method_60118((class_3218)serverLevel, (class_1799)itemStack, (class_1297)livingEntity, (float)0.0f);
        float i = list.size() == 1 ? 0.0f : 2.0f * spread / (float)(list.size() - 1);
        float j = (float)((list.size() - 1) % 2) * i / 2.0f;
        float k = 1.0f;
        for (int l = 0; l < list.size(); ++l) {
            class_1799 itemStack2 = list.get(l);
            if (itemStack2.method_7960()) continue;
            float m = j + k * (float)((l + 1) / 2) * i;
            k = -k;
            class_1676 projectile = this.createProjectile((class_1937)serverLevel, livingEntity, itemStack, itemStack2, fullPower);
            this.shootProjectile(livingEntity, projectile, f, 1.0f, m);
            serverLevel.method_8649((class_1297)projectile);
            itemStack.method_71012(this.getDurabilityUse(itemStack2), livingEntity, interactionHand);
            if (itemStack.method_7960()) break;
        }
    }

    protected int getDurabilityUse(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8639) ? 3 : 1;
    }

    protected class_1676 createProjectile(class_1937 level, class_1309 livingEntity, class_1799 itemStack, class_1799 itemStack2, boolean bl) {
        if (itemStack2.method_31574(class_1802.field_8639)) {
            return new class_1671(level, itemStack2, (class_1297)livingEntity, livingEntity.method_23317(), livingEntity.method_23320() - (double)0.15f, livingEntity.method_23321(), true);
        }
        return this.createArrow(level, livingEntity, itemStack, itemStack2, bl);
    }

    protected class_1676 createArrow(class_1937 level, class_1309 livingEntity, class_1799 itemStack, class_1799 itemStack2, boolean crit) {
        class_1792 item = itemStack2.method_7909();
        class_1744 arrowItem = item instanceof class_1744 ? (class_1744)item : (class_1744)class_1802.field_8107;
        class_1665 abstractArrow = arrowItem.method_7702(level, itemStack2, livingEntity, itemStack);
        if (crit) {
            abstractArrow.method_7439(true);
        }
        return abstractArrow;
    }

    @Override
    public boolean releaseUsing(class_1799 itemStack, class_1937 level, class_1309 livingEntity, int useDuration) {
        if (!(livingEntity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)livingEntity;
        class_1799 itemStack2 = this.getProjectile(player);
        if (itemStack2.method_7960()) {
            return false;
        }
        int j = this.getUseDuration(itemStack, livingEntity).orElseThrow() - useDuration;
        float currentPower = class_1753.method_7722((int)j);
        if ((double)currentPower < 0.1) {
            return false;
        }
        List<class_1799> list = ProjectileWeaponItemInvoker.invokeDraw(itemStack, itemStack2, (class_1309)player);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (!list.isEmpty()) {
                this.shoot(serverLevel, (class_1309)player, player.method_6058(), itemStack, list, currentPower * this.config.powerMultiplier, currentPower == 1.0f);
            }
        }
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3414.method_47908((class_2960)this.config.shootSound), class_3419.field_15248, 1.0f, 1.0f / (level.method_8409().method_43057() * 0.4f + 1.2f) + currentPower * 0.5f);
        player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
        return true;
    }

    public void shootProjectile(class_1309 livingEntity, class_1676 projectile, float f, float g, float h) {
        projectile.method_24919((class_1297)livingEntity, livingEntity.method_36455(), livingEntity.method_36454() + h, 0.0f, f, g);
    }

    @Override
    public Optional<Integer> getUseDuration(class_1799 itemStack, class_1309 livingEntity) {
        return Optional.of(72000);
    }

    @Override
    public class_1839 getUseAnimation(class_1799 itemStack) {
        return class_1839.field_8953;
    }

    @Override
    public class_1269 use(class_1792 item, class_1937 level, class_1657 player, class_1268 interactionHand) {
        boolean hasProjectile;
        boolean bl = hasProjectile = !this.getProjectile(player).method_7960();
        if (player.method_56992() || hasProjectile) {
            player.method_6019(interactionHand);
            return class_1269.field_21466;
        }
        return class_1269.field_5814;
    }

    public Predicate<class_1799> supportedProjectiles() {
        return itemStack -> {
            for (class_2960 itemId : this.config.supportedProjectiles) {
                if (!itemStack.method_41406((class_6880)class_7923.field_41178.method_10223(itemId).orElseThrow())) continue;
                return true;
            }
            return false;
        };
    }

    public Predicate<class_1799> supportedHeldProjectiles() {
        return itemStack -> {
            for (class_2960 itemId : this.config.supportedHeldProjectiles) {
                if (!itemStack.method_41406((class_6880)class_7923.field_41178.method_10223(itemId).orElseThrow())) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public void generate(Data<?> data) {
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> ItemAssetGenerator.createBow(resourcePackBuilder, data.id(), Objects.requireNonNull(data.itemResource()), data.components().method_57832(class_9334.field_49644) || data.vanillaItem().method_57347().method_57832(class_9334.field_49644)));
    }

    @Override
    public List<String> requiredModels() {
        return List.of("pulling_0", "pulling_1", "pulling_2");
    }

    public class_1799 getProjectile(class_1657 shooter) {
        Predicate<class_1799> predicate = this.supportedHeldProjectiles();
        class_1799 itemStack = class_1811.method_18815((class_1309)shooter, predicate);
        if (!itemStack.method_7960()) {
            return itemStack;
        }
        predicate = this.supportedProjectiles();
        for (int i = 0; i < shooter.method_31548().method_5439(); ++i) {
            class_1799 itemStack2 = shooter.method_31548().method_5438(i);
            if (!predicate.test(itemStack2)) continue;
            return itemStack2;
        }
        return shooter.method_56992() ? new class_1799((class_1935)class_1802.field_8107) : class_1799.field_8037;
    }

    public static class Config {
        public float powerMultiplier = 3.0f;
        public List<class_2960> supportedProjectiles = ImmutableList.of((Object)class_2960.method_60656((String)"arrow"), (Object)class_2960.method_60656((String)"spectral_arrow"));
        public List<class_2960> supportedHeldProjectiles = ImmutableList.of((Object)class_2960.method_60656((String)"arrow"), (Object)class_2960.method_60656((String)"spectral_arrow"), (Object)class_2960.method_60656((String)"firework_rocket"));
        public class_2960 shootSound = class_3417.field_14600.comp_3319();
    }
}

