/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.gui;

import de.tomalbrc.filament.gui.VirtualChestMenu;
import de.tomalbrc.filament.util.FilamentContainer;
import de.tomalbrc.filament.util.Util;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class PaginatedContainerGui
extends SimpleGui {
    GuiElementBuilder empty = GuiElementBuilder.from((class_1799)class_1802.field_8407.method_7854()).hideDefaultTooltip().hideTooltip().model(Util.id("blank_gui"));
    private final class_1263 container;
    private int currentPage = 0;

    public PaginatedContainerGui(class_3917<?> type, class_3222 player, boolean manipulatePlayerSlots, class_1263 container) {
        super(type, player, manipulatePlayerSlots);
        this.container = container;
        this.populateFromContainer(this.currentPage);
    }

    private int slotsPerPage() {
        int w = this.getWidth();
        int h = this.getHeight() - 1;
        return w * h;
    }

    private void populateButtons() {
        int pages = Math.max(0, (this.container.method_5439() - 1) / this.slotsPerPage());
        for (int i = 0; i < this.getWidth(); ++i) {
            this.setSlot(GuiHelpers.posToIndex((int)i, (int)(this.getHeight() - 1), (int)this.getHeight(), (int)this.getWidth()), (GuiElementInterface)this.empty.build());
        }
        int prevIdx = GuiHelpers.posToIndex((int)3, (int)(this.getHeight() - 1), (int)this.getHeight(), (int)this.getWidth());
        if (this.currentPage > 0) {
            this.setSlot(prevIdx, GuiElementBuilder.from((class_1799)class_1802.field_8407.method_7854()).hideDefaultTooltip().setName((class_2561)class_2561.method_43471((String)"book.page_button.previous")).addLoreLine((class_2561)class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(this.currentPage + 1)), class_2561.method_43470((String)String.valueOf(pages + 1))}).method_27692(class_124.field_1063)).model(Util.id("previous_gui")).setCallback(() -> {
                if (this.currentPage > 0) {
                    this.populateFromContainer(this.currentPage - 1);
                }
            }));
        }
        int nextIdx = GuiHelpers.posToIndex((int)(this.getWidth() - 4), (int)(this.getHeight() - 1), (int)this.getHeight(), (int)this.getWidth());
        if (this.currentPage < pages) {
            this.setSlot(nextIdx, GuiElementBuilder.from((class_1799)class_1802.field_8407.method_7854()).hideDefaultTooltip().setName((class_2561)class_2561.method_43471((String)"book.page_button.next")).addLoreLine((class_2561)class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(this.currentPage + 1)), class_2561.method_43470((String)String.valueOf(pages + 1))}).method_27692(class_124.field_1063)).model(Util.id("next_gui")).setCallback(() -> {
                int slotsPerPage = this.getWidth() * (this.getHeight() - 1);
                int maxPage = Math.max(0, (this.container.method_5439() - 1) / slotsPerPage);
                if (this.currentPage < maxPage) {
                    this.populateFromContainer(this.currentPage + 1);
                }
            }));
        }
    }

    private void populateFromContainer(int page) {
        boolean singleRowMode;
        int w = this.getWidth();
        int h = this.getHeight() - (this.getHeight() == 1 ? 0 : 1);
        int containerSize = this.container.method_5439();
        int slotsPerPage = this.slotsPerPage();
        int startIndex = page * slotsPerPage;
        if (startIndex >= containerSize) {
            this.currentPage = Math.max(0, (containerSize - 1) / slotsPerPage);
            startIndex = this.currentPage * slotsPerPage;
        } else if (page < 0) {
            this.currentPage = 0;
            startIndex = 0;
        } else {
            this.currentPage = page;
        }
        int xOffset = 0;
        boolean bl = singleRowMode = h == 1 && containerSize <= w;
        if (singleRowMode) {
            xOffset = (w - containerSize) / 2;
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int adjustedX;
                int slotInGui = GuiHelpers.posToIndex((int)x, (int)y, (int)h, (int)w);
                int slotInContainer = singleRowMode ? ((adjustedX = x - xOffset) >= 0 && adjustedX < containerSize ? adjustedX : -1) : startIndex + (y * w + x);
                if (slotInContainer >= 0 && slotInContainer < containerSize) {
                    this.setSlotRedirect(slotInGui, PaginatedContainerGui.createSlot(this.container, slotInContainer));
                    continue;
                }
                this.setSlot(slotInGui, (GuiElementInterface)this.empty.build());
            }
        }
        if (this.getHeight() > 1) {
            this.populateButtons();
        }
    }

    public void setScreenHandler(VirtualChestMenu virtualChestMenu) {
        this.screenHandler = virtualChestMenu;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public static class_1735 createSlot(class_1263 container, final int slotInContainer) {
        return new class_1735(container, slotInContainer, 0, 0){

            public int method_7676(class_1799 itemStack) {
                int n;
                class_1263 class_12632 = this.field_7871;
                if (class_12632 instanceof FilamentContainer) {
                    FilamentContainer filamentContainer = (FilamentContainer)class_12632;
                    n = filamentContainer.getMaxStackSize(slotInContainer);
                } else {
                    n = this.field_7871.method_58350(itemStack);
                }
                return n;
            }

            public boolean method_7680(class_1799 itemStack) {
                if (FilamentContainer.isPickUpContainer(this.field_7871)) {
                    return itemStack.method_7909().method_31568();
                }
                return super.method_7680(itemStack);
            }
        };
    }
}

