/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.mixin.behaviour.cosmetic;

import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.event.FilamentCosmeticEvents;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.item.Cosmetic;
import de.tomalbrc.filament.cosmetic.AnimatedCosmeticHolder;
import de.tomalbrc.filament.cosmetic.CosmeticHolder;
import de.tomalbrc.filament.cosmetic.CosmeticInterface;
import de.tomalbrc.filament.cosmetic.CosmeticUtil;
import de.tomalbrc.filament.item.SimpleItem;
import de.tomalbrc.filament.registry.FilamentComponents;
import de.tomalbrc.filament.registry.ModelRegistry;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.impl.EntityExt;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10192;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9274;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements CosmeticInterface {
    @Unique
    private final Map<String, ElementHolder> filamentCosmeticHolder = new Object2ObjectOpenHashMap();
    @Unique
    private double filamentPrevX = 0.0;
    @Unique
    private double filamentPrevZ = 0.0;
    @Unique
    private double filamentBodyYaw;
    @Unique
    boolean filamentEquipAfterLoad = true;

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract class_1304 method_32326(class_1799 var1);

    @Inject(method={"getEquipmentSlotForItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void filament$customGetEquipmentSlotForItem(class_1799 itemStack, CallbackInfoReturnable<class_1304> cir) {
        class_1799 wrapped;
        class_1304 es;
        if (itemStack.method_57826(FilamentComponents.SKIN_DATA_COMPONENT) && (es = this.method_32326(wrapped = (class_1799)itemStack.method_58694(FilamentComponents.SKIN_DATA_COMPONENT))) != class_1304.field_6173) {
            cir.setReturnValue((Object)es);
            return;
        }
        Cosmetic.Config cosmetic = CosmeticUtil.getCosmeticData(itemStack);
        if (cosmetic != null) {
            cir.setReturnValue((Object)cosmetic.slot);
        }
    }

    @Inject(method={"onEquipItem"}, at={@At(value="HEAD")})
    private void filament$customOnEquipItem(class_1304 equipmentSlot, class_1799 oldItemStack, class_1799 newItemStack, CallbackInfo ci) {
        class_1304 slot;
        class_10192 component;
        if (equipmentSlot == class_1304.field_6169 || equipmentSlot == class_1304.field_6171 || equipmentSlot == class_1304.field_6173) {
            return;
        }
        if (CosmeticUtil.isCosmetic(oldItemStack)) {
            component = (class_10192)oldItemStack.method_58694(class_9334.field_54196);
            class_1304 class_13042 = slot = component == null ? Objects.requireNonNull((Cosmetic)((SimpleItem)oldItemStack.method_7909()).get(Behaviours.COSMETIC)).getConfig().slot : component.comp_3174();
            if (slot == equipmentSlot) {
                this.filament$destroyHolder(slot.method_5923());
                ((FilamentCosmeticEvents.CosmeticEquipmentChange)FilamentCosmeticEvents.UNEQUIPPED.invoker()).onChange((class_1309)class_1309.class.cast(this), oldItemStack, newItemStack);
            }
        }
        if (oldItemStack.method_7960() && !CosmeticUtil.isCosmetic(this.method_6118(this.method_32326(newItemStack))) && (component = (class_10192)newItemStack.method_58694(class_9334.field_54196)) != null) {
            this.filament$destroyHolder(component.comp_3174().method_5923());
            ((FilamentCosmeticEvents.CosmeticEquipmentChange)FilamentCosmeticEvents.UNEQUIPPED.invoker()).onChange((class_1309)class_1309.class.cast(this), oldItemStack, newItemStack);
        }
        if (CosmeticUtil.isCosmetic(newItemStack)) {
            component = (class_10192)newItemStack.method_58694(class_9334.field_54196);
            class_1304 class_13043 = slot = component == null ? Objects.requireNonNull((Cosmetic)((SimpleItem)newItemStack.method_7909()).get(Behaviours.COSMETIC)).getConfig().slot : component.comp_3174();
            if (slot == equipmentSlot || oldItemStack.method_7960()) {
                this.filament$destroyHolder(slot.method_5923());
                ((FilamentCosmeticEvents.CosmeticEquipmentChange)FilamentCosmeticEvents.UNEQUIPPED.invoker()).onChange((class_1309)class_1309.class.cast(this), oldItemStack, newItemStack);
                this.filament$addHolder((class_1309)class_1309.class.cast(this), newItemStack.method_7909(), newItemStack, slot.method_5923());
                ((FilamentCosmeticEvents.CosmeticEquipmentChange)FilamentCosmeticEvents.EQUIPPED.invoker()).onChange((class_1309)class_1309.class.cast(this), oldItemStack, newItemStack);
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void filament$onRemove(class_1297.class_5529 removalReason, CallbackInfo ci) {
        class_1309 self = (class_1309)class_1309.class.cast(this);
        for (class_1304 equipmentSlot : class_9274.field_49224) {
            class_1799 itemStack = this.method_6118(equipmentSlot);
            if (!CosmeticUtil.isCosmetic(itemStack)) continue;
            this.filament$destroyHolder(self.method_32326(itemStack).method_5923());
            ((FilamentCosmeticEvents.CosmeticEquipmentChange)FilamentCosmeticEvents.UNEQUIPPED.invoker()).onChange((class_1309)class_1309.class.cast(this), itemStack, class_1799.field_8037);
        }
    }

    @Override
    @Unique
    public void filament$addHolder(class_1309 livingEntity, class_1792 simpleItem, class_1799 itemStack, String slot) {
        Cosmetic.Config cosmeticData = CosmeticUtil.getCosmeticData(itemStack);
        Object holder = null;
        if (cosmeticData.model != null && !this.filamentCosmeticHolder.containsKey(slot)) {
            holder = new AnimatedCosmeticHolder(livingEntity, ModelRegistry.getModel(cosmeticData.model));
        } else if (!this.filamentCosmeticHolder.containsKey(slot)) {
            holder = new CosmeticHolder(livingEntity, itemStack);
        }
        if (holder == null) {
            Filament.LOGGER.error("Could not create cosmetic holder");
            return;
        }
        EntityAttachment.ofTicking(holder, (class_1297)livingEntity);
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            holder.startWatching(serverPlayer);
        }
        VirtualEntityUtils.addVirtualPassenger((class_1297)livingEntity, (int[])holder.getEntityIds().toIntArray());
        class_2752 packet = VirtualEntityUtils.createRidePacket((int)livingEntity.method_5628(), (IntList)((EntityExt)livingEntity).polymerVE$getVirtualRidden());
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            serverPlayer.field_13987.method_14364((class_2596)packet);
        }
        if (cosmeticData.autoplay != null && holder instanceof AnimatedCosmeticHolder) {
            AnimatedCosmeticHolder animatedHolder = (AnimatedCosmeticHolder)((Object)holder);
            animatedHolder.getAnimator().playAnimation(cosmeticData.autoplay);
        }
        this.filamentCosmeticHolder.put(slot, (ElementHolder)holder);
    }

    @Override
    @Unique
    public void filament$destroyHolder(String slot) {
        if (this.filamentCosmeticHolder.containsKey(slot)) {
            ElementHolder holder = this.filamentCosmeticHolder.get(slot);
            VirtualEntityUtils.removeVirtualPassenger((class_1297)((class_1297)class_1309.class.cast(this)), (int[])holder.getEntityIds().toIntArray());
            HolderAttachment attachment = this.filamentCosmeticHolder.get(slot).getAttachment();
            if (attachment != null) {
                attachment.destroy();
            }
            this.filamentCosmeticHolder.get(slot).destroy();
            this.filamentCosmeticHolder.remove(slot);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void rotationTick(CallbackInfo ci) {
        class_1309 self = (class_1309)class_1309.class.cast(this);
        boolean isPlayer = self instanceof class_1657;
        if (this.filamentEquipAfterLoad && !isPlayer) {
            for (class_1304 slot : class_9274.field_49224.method_66665()) {
                class_1799 stack = this.method_6118(slot);
                if (!CosmeticUtil.isCosmetic(stack) || slot == class_1304.field_6169) continue;
                this.filament$addHolder(self, stack.method_7909(), stack, slot.method_5923());
                ((FilamentCosmeticEvents.CosmeticEquipmentChange)FilamentCosmeticEvents.EQUIPPED.invoker()).onChange((class_1309)class_1309.class.cast(this), class_1799.field_8037, stack);
            }
            this.filamentEquipAfterLoad = false;
        }
        if (!this.filamentCosmeticHolder.isEmpty() && this.filamentPrevX != 0.0 && this.filamentPrevZ != 0.0 && isPlayer) {
            this.filament$tickMovement(self);
        } else {
            this.filamentBodyYaw = self.field_6283;
        }
        this.filamentPrevX = self.method_23317();
        this.filamentPrevZ = self.method_23321();
    }

    @Unique
    private void filament$tickMovement(class_1309 entity) {
        double yaw = entity.method_36454();
        double i = entity.method_23317() - this.filamentPrevX;
        double d = entity.method_23321() - this.filamentPrevZ;
        double f = (float)(i * i + d * d);
        double g = this.filamentBodyYaw;
        if (f > 0.0025) {
            double l = Math.atan2(d, i) * 57.2957763671875 - 90.0;
            double m = Math.abs(class_3532.method_15338((double)yaw) - l);
            g = 95.0 < m && m < 265.0 ? l - 180.0 : l;
        }
        this.filament$turnBody(g, yaw);
    }

    @Unique
    public void filament$turnBody(double bodyRotation, double yaw) {
        double f = class_3532.method_15338((double)(bodyRotation - this.filamentBodyYaw));
        this.filamentBodyYaw += f * (double)0.3f;
        double g = class_3532.method_15338((double)(yaw - this.filamentBodyYaw));
        if (g < -75.0) {
            g = -75.0;
        }
        if (g >= 75.0) {
            g = 75.0;
        }
        this.filamentBodyYaw = yaw - g;
        if (g * g > 2500.0) {
            this.filamentBodyYaw += g * 0.25;
        }
    }

    @Override
    @Unique
    public float filament$bodyYaw() {
        return (float)this.filamentBodyYaw;
    }
}

