/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.snakeyaml.nodes;

import de.tomalbrc.filament.snakeyaml.DumperOptions;
import de.tomalbrc.filament.snakeyaml.error.Mark;
import de.tomalbrc.filament.snakeyaml.nodes.CollectionNode;
import de.tomalbrc.filament.snakeyaml.nodes.Node;
import de.tomalbrc.filament.snakeyaml.nodes.NodeId;
import de.tomalbrc.filament.snakeyaml.nodes.Tag;
import java.util.List;

public class SequenceNode
extends CollectionNode<Node> {
    private final List<Node> value;

    public SequenceNode(Tag tag, boolean resolved, List<Node> value, Mark startMark, Mark endMark, DumperOptions.FlowStyle flowStyle) {
        super(tag, startMark, endMark, flowStyle);
        if (value == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = value;
        this.resolved = resolved;
    }

    public SequenceNode(Tag tag, List<Node> value, DumperOptions.FlowStyle flowStyle) {
        this(tag, true, value, null, null, flowStyle);
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.sequence;
    }

    @Override
    public List<Node> getValue() {
        return this.value;
    }

    public void setListType(Class<? extends Object> listType) {
        for (Node node : this.value) {
            node.setType(listType);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Node node : this.getValue()) {
            if (node instanceof CollectionNode) {
                buf.append(System.identityHashCode(node));
            } else {
                buf.append(node.toString());
            }
            buf.append(",");
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", value=[" + buf + "])>";
    }
}

