/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.registry.BehaviourRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;

public class BehaviourConfigMap {
    public static final BehaviourConfigMap EMPTY = new BehaviourConfigMap();
    private final Map<BehaviourType<? extends Behaviour<?>, ?>, Object> behaviourConfigMap = new Object2ObjectOpenHashMap();

    public void put(BehaviourType<?, ?> type, Object config) {
        this.behaviourConfigMap.put(type, config);
    }

    public <T extends Behaviour<E>, E> E get(BehaviourType<T, E> type) {
        return (E)this.behaviourConfigMap.get(type);
    }

    public <T extends Behaviour<E>, E> boolean has(BehaviourType<T, E> type) {
        return this.behaviourConfigMap.containsKey(type);
    }

    public <T extends Behaviour<E>, E> void forEach(BiConsumer<BehaviourType<T, E>, Object> biConsumer) {
        for (Map.Entry<BehaviourType<Behaviour<?>, ?>, Object> entry : this.behaviourConfigMap.entrySet()) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.behaviourConfigMap.isEmpty();
    }

    public static class Deserializer
    implements JsonDeserializer<BehaviourConfigMap> {
        public BehaviourConfigMap deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject object = jsonElement.getAsJsonObject();
            BehaviourConfigMap behaviourConfigMap = new BehaviourConfigMap();
            for (Map.Entry entry : object.entrySet()) {
                class_2960 resourceLocation = ((String)entry.getKey()).contains(":") ? class_2960.method_60654((String)((String)entry.getKey())) : class_2960.method_60655((String)"filament", (String)((String)entry.getKey()));
                BehaviourType behaviourType = BehaviourRegistry.getType(resourceLocation);
                if (behaviourType == null || behaviourType.configType() == null) {
                    Filament.LOGGER.error("Could not load behaviour " + String.valueOf(resourceLocation));
                    continue;
                }
                Class clazz = behaviourType.configType();
                Object deserialized = jsonDeserializationContext.deserialize((JsonElement)entry.getValue(), clazz);
                behaviourConfigMap.put(BehaviourRegistry.getType(resourceLocation), deserialized);
            }
            return behaviourConfigMap;
        }
    }
}

