/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.util.FilamentBlockResourceUtils;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Door
implements BlockBehaviour<Config> {
    private final Config config;

    public Door(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        class_2756 doubleBlockHalf = (class_2756)blockState.method_11654((class_2769)class_2741.field_12533);
        if (direction.method_10166() == class_2350.class_2351.field_11052 && doubleBlockHalf == class_2756.field_12607 == (direction == class_2350.field_11036)) {
            if (this.isSame(blockState2.method_26204()) && blockState2.method_11654((class_2769)class_2741.field_12533) != doubleBlockHalf) {
                return (class_2680)blockState2.method_11657((class_2769)class_2741.field_12533, (Comparable)doubleBlockHalf);
            }
            return class_2246.field_10124.method_9564();
        }
        if (doubleBlockHalf == class_2756.field_12607 && direction == class_2350.field_11033 && !blockState.method_26184(levelReader, blockPos)) {
            return class_2246.field_10124.method_9564();
        }
        return BlockBehaviour.super.updateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, blockPos2, blockState2, randomSource);
    }

    @Override
    public void onExplosionHit(class_2680 blockState, class_3218 level, class_2338 blockPos, class_1927 explosion, BiConsumer<class_1799, class_2338> biConsumer) {
        if (explosion.method_60274() && blockState.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607 && this.config.canOpenByWindCharge && !((Boolean)blockState.method_11654((class_2769)class_2741.field_12484)).booleanValue()) {
            this.setOpen(null, (class_1937)level, blockState, blockPos, !this.isOpen(blockState));
        }
    }

    @Override
    public void playerWillDestroy(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        if (!(level.field_9236 || !player.method_68878() && player.method_7305(blockState))) {
            class_2320.method_30036((class_1937)level, (class_2338)blockPos, (class_2680)blockState, (class_1657)player);
        }
    }

    @Override
    public Optional<Boolean> isPathfindable(class_2680 blockState, class_10 pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new MatchException(null, null);
            case class_10.field_50, class_10.field_51 -> Optional.of((Boolean)blockState.method_11654((class_2769)class_2741.field_12537));
            case class_10.field_48 -> Optional.of(false);
        };
    }

    @Override
    @Nullable
    public class_2680 getStateForPlacement(class_2680 self, class_1750 blockPlaceContext) {
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_1937 level = blockPlaceContext.method_8045();
        if (level.method_62871(blockPos.method_10264()) && level.method_8320(blockPos.method_10084()).method_26166(blockPlaceContext)) {
            boolean powered = level.method_49803(blockPos) || level.method_49803(blockPos.method_10084());
            return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)self.method_26204().method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)blockPlaceContext.method_8042())).method_11657((class_2769)class_2741.field_12520, (Comparable)this.getHinge(blockPlaceContext))).method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(powered))).method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(powered))).method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607);
        }
        return null;
    }

    @Override
    public void setPlacedBy(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1309 livingEntity, class_1799 itemStack) {
        level.method_8652(blockPos.method_10084(), (class_2680)blockState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609), 3);
    }

    private boolean isSame(class_2248 block) {
        SimpleBlock simpleBlock;
        return block instanceof SimpleBlock && (simpleBlock = (SimpleBlock)block).has(Behaviours.DOOR) && simpleBlock.get(Behaviours.DOOR) == this;
    }

    private class_2750 getHinge(class_1750 blockPlaceContext) {
        boolean bl2;
        class_1937 blockGetter = blockPlaceContext.method_8045();
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_2350 direction = blockPlaceContext.method_8042();
        class_2338 blockPos2 = blockPos.method_10084();
        class_2350 direction2 = direction.method_10160();
        class_2338 blockPos3 = blockPos.method_10093(direction2);
        class_2680 blockState = blockGetter.method_8320(blockPos3);
        class_2338 blockPos4 = blockPos2.method_10093(direction2);
        class_2680 blockState2 = blockGetter.method_8320(blockPos4);
        class_2350 direction3 = direction.method_10170();
        class_2338 blockPos5 = blockPos.method_10093(direction3);
        class_2680 blockState3 = blockGetter.method_8320(blockPos5);
        class_2338 blockPos6 = blockPos2.method_10093(direction3);
        class_2680 blockState4 = blockGetter.method_8320(blockPos6);
        int i = (blockState.method_26234((class_1922)blockGetter, blockPos3) ? -1 : 0) + (blockState2.method_26234((class_1922)blockGetter, blockPos4) ? -1 : 0) + (blockState3.method_26234((class_1922)blockGetter, blockPos5) ? 1 : 0) + (blockState4.method_26234((class_1922)blockGetter, blockPos6) ? 1 : 0);
        boolean bl = this.isSame(blockState.method_26204()) && blockState.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607;
        boolean bl3 = bl2 = this.isSame(blockState3.method_26204()) && blockState3.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607;
        if (bl && !bl2 || i > 0) {
            return class_2750.field_12586;
        }
        if (bl2 && !bl || i < 0) {
            return class_2750.field_12588;
        }
        int j = direction.method_10148();
        int k = direction.method_10165();
        class_243 vec3 = blockPlaceContext.method_17698();
        double d = vec3.field_1352 - (double)blockPos.method_10263();
        double e = vec3.field_1350 - (double)blockPos.method_10260();
        return j < 0 && e < 0.5 || j > 0 && e > 0.5 || k < 0 && d > 0.5 || k > 0 && d < 0.5 ? class_2750.field_12586 : class_2750.field_12588;
    }

    @Override
    public class_1269 useWithoutItem(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        if (!this.config.canOpenByHand) {
            return class_1269.field_5811;
        }
        blockState = (class_2680)blockState.method_28493((class_2769)class_2741.field_12537);
        level.method_8652(blockPos, blockState, 10);
        this.playSound((class_1297)player, level, blockPos, (Boolean)blockState.method_11654((class_2769)class_2741.field_12537));
        level.method_33596((class_1297)player, (class_6880)(this.isOpen(blockState) ? class_5712.field_28168 : class_5712.field_28169), blockPos);
        return class_1269.field_52422;
    }

    public boolean isOpen(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)class_2741.field_12537);
    }

    public void setOpen(@Nullable class_1297 entity, class_1937 level, class_2680 blockState, class_2338 blockPos, boolean bl) {
        SimpleBlock simpleBlock;
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof SimpleBlock) || !(simpleBlock = (SimpleBlock)class_22482).has(Behaviours.DOOR) || (Boolean)blockState.method_11654((class_2769)class_2741.field_12537) == bl) {
            return;
        }
        level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(bl)), 10);
        this.playSound(entity, level, blockPos, bl);
        level.method_33596(entity, (class_6880)(bl ? class_5712.field_28168 : class_5712.field_28169), blockPos);
    }

    @Override
    public void neighborChanged(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_9904 orientation, boolean bl) {
        boolean bl2;
        boolean bl3 = level.method_49803(blockPos) || level.method_49803(blockPos.method_10093(blockState.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607 ? class_2350.field_11036 : class_2350.field_11033)) ? true : (bl2 = false);
        if (!blockState.method_26204().method_9564().method_27852(block) && bl2 != (Boolean)blockState.method_11654((class_2769)class_2741.field_12484)) {
            if (bl2 != (Boolean)blockState.method_11654((class_2769)class_2741.field_12537)) {
                this.playSound(null, level, blockPos, bl2);
                level.method_33596(null, (class_6880)(bl2 ? class_5712.field_28168 : class_5712.field_28169), blockPos);
            }
            level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(bl2))).method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(bl2)), 2);
        }
    }

    @Override
    public boolean canSurvive(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        SimpleBlock simpleBlock;
        class_2338 blockPos2 = blockPos.method_10074();
        class_2680 blockState2 = levelReader.method_8320(blockPos2);
        if (blockState.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607) {
            return blockState2.method_26206((class_1922)levelReader, blockPos2, class_2350.field_11036);
        }
        class_2248 class_22482 = blockState2.method_26204();
        return class_22482 instanceof SimpleBlock && (simpleBlock = (SimpleBlock)class_22482).has(Behaviours.DOOR);
    }

    private void playSound(@Nullable class_1297 entity, class_1937 level, class_2338 blockPos, boolean open) {
        level.method_8396(entity, blockPos, class_3414.method_47908((class_2960)(open ? this.config.openSound : this.config.closeSound)), class_3419.field_15245, 1.0f, level.method_8409().method_43057() * 0.1f + 0.9f);
    }

    @Override
    public class_2680 rotate(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)class_2741.field_12481, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)class_2741.field_12481)));
    }

    @Override
    public class_2680 mirror(class_2680 blockState, class_2415 mirror) {
        if (mirror == class_2415.field_11302) {
            return blockState;
        }
        return (class_2680)blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)class_2741.field_12481))).method_28493((class_2769)class_2741.field_12520);
    }

    @Override
    public Optional<Long> getSeed(class_2680 blockState, class_2338 blockPos) {
        return Optional.of(class_3532.method_15371((int)blockPos.method_10263(), (int)blockPos.method_10087(blockState.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607 ? 0 : 1).method_10264(), (int)blockPos.method_10260()));
    }

    @Override
    public boolean createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12533, class_2741.field_12481, class_2741.field_12537, class_2741.field_12520, class_2741.field_12484});
        return true;
    }

    @Override
    public class_2680 modifyDefaultState(class_2680 blockState) {
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12520, (Comparable)class_2750.field_12588)).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607);
    }

    @Override
    public boolean modifyStateMap(Map<class_2680, BlockData.BlockStateMeta> map, BlockData data) {
        for (Map.Entry<String, PolymerBlockModel> entry : data.blockResource().models().entrySet()) {
            class_2259.class_7211 parsed;
            PolymerBlockModel blockModel = entry.getValue();
            String str = String.format("%s[%s]", data.id(), entry.getKey());
            try {
                parsed = class_2259.method_41957((class_7225)class_7923.field_41175, (String)str, (boolean)false);
            }
            catch (CommandSyntaxException e) {
                throw new JsonParseException("Invalid BlockState value: " + str);
            }
            map.put(parsed.comp_622(), BlockData.BlockStateMeta.of(this.doorState(parsed, blockModel, data.virtual()), blockModel));
        }
        return true;
    }

    private class_2680 doorState(class_2259.class_7211 parsed, PolymerBlockModel blockModel, boolean virtual) {
        class_2680 requestedState = null;
        if (((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue() && parsed.comp_622().method_11654((class_2769)class_2741.field_12520) == class_2750.field_12586) {
            if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11043) {
                requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.WEST_DOOR, blockModel, virtual);
            } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11034) {
                requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.NORTH_DOOR, blockModel, virtual);
            } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11035) {
                requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.EAST_DOOR, blockModel, virtual);
            } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11039) {
                requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.SOUTH_DOOR, blockModel, virtual);
            }
        } else if (((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue() && parsed.comp_622().method_11654((class_2769)class_2741.field_12520) == class_2750.field_12588) {
            if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11043) {
                requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.EAST_DOOR, blockModel, virtual);
            } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11034) {
                requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.SOUTH_DOOR, blockModel, virtual);
            } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11035) {
                requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.WEST_DOOR, blockModel, virtual);
            } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11039) {
                requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.NORTH_DOOR, blockModel, virtual);
            }
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11043) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.NORTH_DOOR, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11034) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.EAST_DOOR, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11035) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.SOUTH_DOOR, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11039) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.WEST_DOOR, blockModel, virtual);
        }
        return requestedState;
    }

    @Override
    public class_2680 filteredBlockState(class_2680 blockState) {
        return (class_2680)blockState.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(false));
    }

    public static class Config {
        public boolean canOpenByWindCharge = true;
        public boolean canOpenByHand = true;
        public class_2960 openSound = class_3417.field_14664.comp_3319();
        public class_2960 closeSound = class_3417.field_14541.comp_3319();
    }
}

