/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.util.BlockUtil;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_8813;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class Sapling
implements BlockBehaviour<Config>,
class_2256 {
    private final Config config;
    private class_8813 treeGrower;

    public Sapling(Config config) {
        this.config = config;
    }

    @Override
    public void init(class_1792 item, class_2248 block, BehaviourHolder behaviourHolder) {
        BlockBehaviour.super.init(item, block, behaviourHolder);
        String name = UUID.randomUUID().toString();
        this.treeGrower = new class_8813(name, this.config.secondaryChance, Optional.ofNullable(this.key(this.config.megaTree)), Optional.ofNullable(this.key(this.config.secondaryMegaTree)), Optional.ofNullable(this.key(this.config.tree)), Optional.ofNullable(this.key(this.config.secondaryTree)), Optional.ofNullable(this.key(this.config.flowers)), Optional.ofNullable(this.key(this.config.secondaryFlowers)));
    }

    @Override
    public boolean modifyStateMap(Map<class_2680, BlockData.BlockStateMeta> map, BlockData blockData) {
        if (map.size() == 1) {
            Map.Entry<class_2680, BlockData.BlockStateMeta> entry = map.entrySet().iterator().next();
            map.put((class_2680)entry.getKey().method_28493((class_2769)class_2741.field_12549), entry.getValue());
        }
        return true;
    }

    @Nullable
    private class_5321<class_2975<?, ?>> key(class_2960 resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        return class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)resourceLocation);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12549});
        return true;
    }

    @Override
    public boolean isRandomlyTicking(class_2680 blockState) {
        return true;
    }

    @Override
    public void randomTick(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (serverLevel.method_22339(blockPos.method_10084()) >= this.config.minLightLevel && randomSource.method_43057() < this.config.randomTickGrowthChance) {
            this.grow(serverLevel, blockPos, blockState, randomSource);
        }
    }

    private void grow(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, class_5819 randomSource) {
        if ((Integer)blockState.method_11654((class_2769)class_2741.field_12549) == 0) {
            serverLevel.method_8652(blockPos, (class_2680)blockState.method_28493((class_2769)class_2741.field_12549), 2);
        } else {
            this.treeGrower.method_54085(serverLevel, serverLevel.method_14178().method_12129(), blockPos, blockState, randomSource);
        }
    }

    public boolean method_9651(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        return true;
    }

    public boolean method_9650(class_1937 level, class_5819 randomSource, class_2338 blockPos, class_2680 blockState) {
        if (level instanceof class_3218) {
            SimpleBlock polymerBlock;
            class_3218 serverLevel = (class_3218)level;
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof SimpleBlock && !((polymerBlock = (SimpleBlock)class_22482).getPolymerBlockState(blockState, PacketContext.create()).method_26204() instanceof class_2256)) {
                BlockUtil.handleBoneMealEffects(serverLevel, blockPos);
            }
        }
        return level.field_9229.method_43057() < this.config.bonemealGrowthChance;
    }

    public void method_9652(class_3218 serverLevel, class_5819 randomSource, class_2338 blockPos, class_2680 blockState) {
        this.grow(serverLevel, blockPos, blockState, randomSource);
    }

    public static class Config {
        int minLightLevel = 9;
        float randomTickGrowthChance = 0.15f;
        float bonemealGrowthChance = 0.45f;
        float secondaryChance = 0.0f;
        class_2960 megaTree = null;
        class_2960 secondaryMegaTree = null;
        class_2960 tree = null;
        class_2960 secondaryTree = null;
        class_2960 flowers = null;
        class_2960 secondaryFlowers = null;
    }
}

