/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.util.FilamentBlockResourceUtils;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Slab
implements BlockBehaviour<SlabConfig>,
class_3737 {
    private final SlabConfig config;

    public Slab(SlabConfig config) {
        this.config = config;
    }

    @Override
    @NotNull
    public SlabConfig getConfig() {
        return this.config;
    }

    @Override
    public class_2680 modifyDefaultState(class_2680 blockState) {
        return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12681)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public Optional<Boolean> useShapeForLightOcclusion(class_2680 blockState) {
        return Optional.of(blockState.method_11654((class_2769)class_2741.field_12485) != class_2771.field_12682);
    }

    @Override
    public boolean createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12485, class_2741.field_12508});
        return true;
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 prevBlockState, class_1750 blockPlaceContext) {
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_2680 blockState = blockPlaceContext.method_8045().method_8320(blockPos);
        if (blockState.method_27852(prevBlockState.method_26204())) {
            return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12682)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
        }
        class_3610 fluidState = blockPlaceContext.method_8045().method_8316(blockPos);
        class_2680 blockState2 = (class_2680)((class_2680)prevBlockState.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12681)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        class_2350 direction = blockPlaceContext.method_8038();
        if (direction == class_2350.field_11033 || direction != class_2350.field_11036 && blockPlaceContext.method_17698().field_1351 - (double)blockPos.method_10264() > 0.5) {
            return (class_2680)blockState2.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12679);
        }
        return blockState2;
    }

    @Override
    public Optional<Boolean> canBeReplaced(class_2680 blockState, class_1750 blockPlaceContext) {
        class_1799 itemStack = blockPlaceContext.method_8041();
        class_2771 slabType = (class_2771)blockState.method_11654((class_2769)class_2741.field_12485);
        if (slabType == class_2771.field_12682 || !itemStack.method_31574(blockState.method_26204().method_8389())) {
            return Optional.of(false);
        }
        if (blockPlaceContext.method_7717()) {
            boolean bl = blockPlaceContext.method_17698().field_1351 - (double)blockPlaceContext.method_8037().method_10264() > 0.5;
            class_2350 direction = blockPlaceContext.method_8038();
            if (slabType == class_2771.field_12681) {
                return Optional.of(direction == class_2350.field_11036 || bl && direction.method_10166().method_10179());
            }
            return Optional.of(direction == class_2350.field_11033 || !bl && direction.method_10166().method_10179());
        }
        return Optional.of(true);
    }

    @Override
    public class_3610 getFluidState(class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return null;
    }

    public boolean method_10311(class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState, class_3610 fluidState) {
        if (blockState.method_11654((class_2769)class_2741.field_12485) != class_2771.field_12682) {
            return super.method_10311(levelAccessor, blockPos, blockState, fluidState);
        }
        return false;
    }

    public boolean method_10310(@Nullable class_1309 livingEntity, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_3611 fluid) {
        if (blockState.method_11654((class_2769)class_2741.field_12485) != class_2771.field_12682) {
            return super.method_10310(livingEntity, blockGetter, blockPos, blockState, fluid);
        }
        return false;
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        return blockState;
    }

    @Override
    public Optional<Boolean> isPathfindable(class_2680 blockState, class_10 pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new MatchException(null, null);
            case class_10.field_50, class_10.field_51 -> Optional.of(false);
            case class_10.field_48 -> Optional.of(blockState.method_26227().method_15767(class_3486.field_15517));
        };
    }

    @Override
    public boolean modifyStateMap(Map<class_2680, BlockData.BlockStateMeta> map, BlockData data) {
        for (Map.Entry<String, PolymerBlockModel> entry : data.blockResource().models().entrySet()) {
            class_2259.class_7211 parsed;
            PolymerBlockModel blockModel = entry.getValue();
            String str = String.format("%s[%s]", data.id(), entry.getKey());
            try {
                parsed = class_2259.method_41957((class_7225)class_7923.field_41175, (String)str, (boolean)false);
            }
            catch (CommandSyntaxException e) {
                throw new JsonParseException("Invalid BlockState value: " + str);
            }
            class_2680 requestedState = parsed.comp_622().method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679 ? FilamentBlockResourceUtils.requestBlock(BlockModelType.TOP_SLAB, blockModel, data.virtual()) : (parsed.comp_622().method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681 ? FilamentBlockResourceUtils.requestBlock(BlockModelType.BOTTOM_SLAB, blockModel, data.virtual()) : FilamentBlockResourceUtils.requestBlock(BlockModelType.FULL_BLOCK, blockModel, data.virtual()));
            map.put(parsed.comp_622(), BlockData.BlockStateMeta.of(requestedState, blockModel));
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            class_2680 blockState = ((BlockData.BlockStateMeta)entry.getValue()).blockState();
            if (!blockState.method_28498((class_2769)class_2482.field_11502) || ((Boolean)blockState.method_11654((class_2769)class_2482.field_11502)).booleanValue() || !blockState.method_28498((class_2769)class_2482.field_11501) || blockState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12682) continue;
            class_2680 res = FilamentBlockResourceUtils.requestBlock(blockState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679 ? BlockModelType.TOP_SLAB_WATERLOGGED : BlockModelType.BOTTOM_SLAB_WATERLOGGED, ((BlockData.BlockStateMeta)entry.getValue()).polymerBlockModel(), data.virtual());
            map.put((class_2680)((class_2680)entry.getKey()).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(true)), BlockData.BlockStateMeta.of(res, ((BlockData.BlockStateMeta)entry.getValue()).polymerBlockModel()));
        }
        return true;
    }

    public static class SlabConfig {
    }
}

