/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.decoration.holder.AnimatedHolder;
import de.tomalbrc.filament.registry.ModelRegistry;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class Animation
implements DecorationBehaviour<AnimationConfig> {
    private final AnimationConfig config;

    public Animation(AnimationConfig config) {
        this.config = config;
    }

    @Override
    @NotNull
    public AnimationConfig getConfig() {
        return this.config;
    }

    @Override
    public ElementHolder createHolder(DecorationBlockEntity blockEntity) {
        Model model = ModelRegistry.getModel(this.config.model);
        if (model != null) {
            return new AnimatedHolder(blockEntity, model);
        }
        Filament.LOGGER.error("No Animated model named '" + String.valueOf(this.config.model) + "' was found!");
        return null;
    }

    @Override
    public void onElementAttach(DecorationBlockEntity blockEntity, ElementHolder holder) {
        if (holder instanceof AnimatedHolder) {
            AnimatedHolder animatedHolder = (AnimatedHolder)holder;
            animatedHolder.setRotation(blockEntity.getVisualRotationYInDegrees());
        }
    }

    public static class AnimationConfig {
        public class_2960 model = null;
        public String autoplay = null;
    }
}

