/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.util.FilamentContainer;
import de.tomalbrc.filament.util.Util;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1707;
import net.minecraft.class_1722;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class Container
implements DecorationBehaviour<ContainerConfig> {
    public final FilamentContainer container;
    private final ContainerConfig config;

    public Container(ContainerConfig config) {
        this.config = config;
        this.container = new FilamentContainer(config.size, config.purge);
    }

    @Override
    @NotNull
    public ContainerConfig getConfig() {
        return this.config;
    }

    @Override
    public void init(DecorationBlockEntity blockEntity) {
        if (this.config.canPickup) {
            Objects.requireNonNull((class_9288)blockEntity.getItem().method_58694(class_9334.field_49622)).method_57492(this.container.field_5828);
        }
    }

    @Override
    public void write(class_2487 compoundTag, class_7225.class_7874 provider, DecorationBlockEntity decorationBlockEntity) {
        compoundTag.method_10566("Container", (class_2520)new class_2487().method_10543(class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.container.field_5828, (class_7225.class_7874)provider)));
    }

    @Override
    public class_1269 interact(class_3222 player, class_1268 hand, class_243 location, DecorationBlockEntity decorationBlockEntity) {
        if (!player.method_21823()) {
            class_5250 containerName = class_2561.method_43470((String)(this.config.name == null ? "filament container" : this.config.name));
            if (this.container.method_5439() % 9 == 0) {
                player.method_17355((class_3908)new class_747((i, playerInventory, playerEntity) -> new class_1707(this.getMenuType(), i, playerInventory, (class_1263)this.container, this.container.method_5439() / 9), (class_2561)containerName));
            } else if (this.container.method_5439() == 5) {
                player.method_17355((class_3908)new class_747((i, playerInventory, playerEntity) -> new class_1722(i, playerInventory, (class_1263)this.container), (class_2561)containerName));
            }
            decorationBlockEntity.method_5431();
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    @Override
    public void read(class_2487 compoundTag, class_7225.class_7874 provider, DecorationBlockEntity decorationBlockEntity) {
        compoundTag.method_10562("Container").ifPresent(x -> class_1262.method_5429((class_2487)x, (class_2371)this.container.field_5828, (class_7225.class_7874)provider));
    }

    @Override
    public void destroy(DecorationBlockEntity decorationBlockEntity, boolean dropItem) {
        if (!this.config.canPickup) {
            this.container.setValid(false);
            for (class_1799 itemStack : this.container.field_5828) {
                if (itemStack.method_7960()) continue;
                Util.spawnAtLocation(decorationBlockEntity.method_10997(), decorationBlockEntity.method_11016().method_46558(), itemStack);
            }
        }
    }

    @Override
    public void modifyDrop(DecorationBlockEntity blockEntity, class_1799 itemStack) {
        if (this.config.canPickup) {
            itemStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)this.container.method_54454()));
        }
    }

    public class_3917<?> getMenuType() {
        return switch (this.config.size) {
            case 9 -> class_3917.field_18664;
            case 18 -> class_3917.field_18665;
            case 27 -> class_3917.field_17326;
            case 36 -> class_3917.field_18666;
            case 45 -> class_3917.field_18667;
            case 54 -> class_3917.field_17327;
            case 5 -> class_3917.field_17337;
            default -> throw new IllegalStateException("Unexpected container size: " + this.config.name + " " + this.config.size);
        };
    }

    public static class ContainerConfig {
        public String name;
        public int size = 9;
        public boolean purge = false;
        public String openAnimation = null;
        public String closeAnimation = null;
        public boolean canPickup = false;
    }
}

