/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import de.tomalbrc.bil.api.AnimatedHolder;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class Lock
implements DecorationBehaviour<LockConfig> {
    public LockConfig lockConfig;
    public boolean unlocked = false;
    public String command = null;

    public Lock(LockConfig lockConfig) {
        this.lockConfig = lockConfig;
    }

    @Override
    @NotNull
    public LockConfig getConfig() {
        return this.lockConfig;
    }

    @Override
    public class_1269 interact(class_3222 player, class_1268 hand, class_243 location, DecorationBlockEntity decorationBlockEntity) {
        boolean noItemNoKey;
        if (this.unlocked) {
            return class_1269.field_5811;
        }
        class_1792 key = this.lockConfig.key == null ? null : (class_1792)class_7923.field_41178.method_63535(this.lockConfig.key);
        class_1799 mainHandItem = player.method_5998(class_1268.field_5808);
        boolean hasHandItem = !mainHandItem.method_7960();
        boolean holdsKeyAndIsValid = hasHandItem && key != null && mainHandItem.method_31574(key);
        boolean bl = noItemNoKey = !hasHandItem && key == null;
        if (holdsKeyAndIsValid || noItemNoKey) {
            boolean validLockCommand;
            ElementHolder elementHolder;
            if (this.lockConfig.consumeKey && hasHandItem) {
                mainHandItem.method_7934(1);
            }
            if (this.lockConfig.unlockAnimation != null && !this.lockConfig.unlockAnimation.isEmpty() && (elementHolder = decorationBlockEntity.getDecorationHolder()) instanceof AnimatedHolder) {
                AnimatedHolder animatedHolder = (AnimatedHolder)elementHolder;
                animatedHolder.getAnimator().playAnimation(this.lockConfig.unlockAnimation);
            }
            this.unlocked = !noItemNoKey;
            List<String> commands = this.commands();
            boolean validCommand = commands != null;
            boolean bl2 = validLockCommand = this.lockConfig.command != null && !this.lockConfig.command.isEmpty();
            if ((validCommand || validLockCommand) && player.method_5682() != null) {
                class_2168 css = player.method_64396().method_36321((class_2165)player.field_13995).method_9230(4);
                if (this.getConfig().atBlock) {
                    css = css.method_9208(decorationBlockEntity.method_11016().method_46558());
                }
                if (validCommand) {
                    for (String cmd : commands) {
                        player.method_5682().method_3734().method_44252(css, cmd);
                    }
                } else {
                    player.method_5682().method_3734().method_44252(css, this.lockConfig.command);
                }
            }
            if (this.lockConfig.discard) {
                decorationBlockEntity.destroyStructure(false);
            }
        }
        return this.unlocked ? class_1269.field_21466 : class_1269.field_5811;
    }

    @Override
    public void read(class_2487 compoundTag, class_7225.class_7874 provider, DecorationBlockEntity blockEntity) {
        compoundTag.method_10562("Lock").ifPresent(lock -> {
            if (compoundTag.method_10545("Command")) {
                this.command = lock.method_10558("Command").orElse(null);
            }
            if (compoundTag.method_10545("Unlocked")) {
                this.unlocked = lock.method_10577("Unlocked").orElse(false);
            }
        });
    }

    @Override
    public void write(class_2487 compoundTag, class_7225.class_7874 provider, DecorationBlockEntity blockEntity) {
        class_2487 lockTag = new class_2487();
        if (this.command != null && !this.command.isEmpty()) {
            lockTag.method_10582("Command", this.command);
        }
        lockTag.method_10556("Unlocked", this.unlocked);
        compoundTag.method_10566("Lock", (class_2520)lockTag);
    }

    private List<String> commands() {
        return this.getConfig().commands == null ? (this.getConfig().command == null ? null : List.of(this.getConfig().command)) : this.getConfig().commands;
    }

    public static class LockConfig {
        public class_2960 key = null;
        public boolean consumeKey = false;
        public boolean discard = false;
        public String unlockAnimation = null;
        public String command = null;
        public List<String> commands = null;
        public boolean atBlock = false;
    }
}

