/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.decoration.holder.DecorationHolder;
import de.tomalbrc.filament.decoration.util.SeatEntity;
import de.tomalbrc.filament.registry.EntityRegistry;
import de.tomalbrc.filament.util.FilamentConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class Seat
implements DecorationBehaviour<SeatConfig> {
    private final SeatConfig seatConfig;

    public Seat(SeatConfig seatConfig) {
        this.seatConfig = seatConfig;
    }

    @Override
    @NotNull
    public SeatConfig getConfig() {
        return this.seatConfig;
    }

    @Override
    public class_1269 interact(class_3222 player, class_1268 hand, class_243 location, DecorationBlockEntity decorationBlockEntity) {
        if (player.method_5854() == null && !player.method_21823() && decorationBlockEntity.getDecorationHolder() instanceof DecorationHolder) {
            SeatMeta seat = this.getClosestSeat(decorationBlockEntity, location);
            if (seat != null && !this.hasSeatedPlayer(decorationBlockEntity, seat)) {
                this.seatPlayer(decorationBlockEntity, seat, player);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public void seatPlayer(DecorationBlockEntity decorationBlockEntity, SeatMeta seat, class_3222 player) {
        SeatEntity seatEntity = (SeatEntity)EntityRegistry.SEAT_ENTITY.method_5883((class_1937)player.method_51469(), class_3730.field_16461);
        assert (seatEntity != null);
        seatEntity.method_33574(this.seatTranslation(decorationBlockEntity, seat).method_1019(decorationBlockEntity.getDecorationHolder().getPos()));
        player.method_37908().method_8649((class_1297)seatEntity);
        player.method_5804((class_1297)seatEntity);
        seatEntity.method_36456(decorationBlockEntity.getVisualRotationYInDegrees() - seat.direction + (float)(FilamentConfig.getInstance().alternativeBlockPlacement ? 180 : 0));
    }

    public boolean hasSeatedPlayer(DecorationBlockEntity decorationBlockEntity, SeatMeta seat) {
        return !Objects.requireNonNull(decorationBlockEntity.method_10997()).method_8390(SeatEntity.class, class_238.method_30048((class_243)this.seatTranslation(decorationBlockEntity, seat).method_1019(decorationBlockEntity.getDecorationHolder().getPos()), (double)0.2, (double)0.2, (double)0.2), x -> true).isEmpty();
    }

    public SeatMeta getClosestSeat(DecorationBlockEntity decorationBlockEntity, class_243 location) {
        if (this.seatConfig.size() == 1) {
            return (SeatMeta)this.seatConfig.getFirst();
        }
        double dist = Double.MAX_VALUE;
        SeatMeta nearest = null;
        ObjectListIterator objectListIterator = this.seatConfig.iterator();
        while (objectListIterator.hasNext()) {
            SeatMeta seat = (SeatMeta)objectListIterator.next();
            class_243 q = decorationBlockEntity.method_11016().method_46558().method_1019(this.seatTranslation(decorationBlockEntity, seat));
            double distance = q.method_1022(location);
            if (this.hasSeatedPlayer(decorationBlockEntity, seat) || !(distance < dist)) continue;
            dist = distance;
            nearest = seat;
        }
        return nearest;
    }

    public class_243 seatTranslation(DecorationBlockEntity decorationBlockEntity, SeatMeta seat) {
        class_243 v3 = new class_243(seat.offset).method_1023(0.0, 0.3, 0.0).method_1024((float)Math.toRadians(decorationBlockEntity.getVisualRotationYInDegrees() + (float)(FilamentConfig.getInstance().alternativeBlockPlacement ? 0 : 180)));
        return new class_243(-v3.field_1352, v3.field_1351, v3.field_1350);
    }

    public SeatEntity getSeatEntity(DecorationBlockEntity decorationBlockEntity, SeatMeta seat) {
        List entities = Objects.requireNonNull(decorationBlockEntity.method_10997()).method_8390(SeatEntity.class, class_238.method_30048((class_243)this.seatTranslation(decorationBlockEntity, seat).method_1019(decorationBlockEntity.getDecorationHolder().getPos()), (double)0.2, (double)0.2, (double)0.2), x -> true);
        if (!entities.isEmpty()) {
            return (SeatEntity)((Object)entities.getFirst());
        }
        return null;
    }

    @Override
    public void destroy(DecorationBlockEntity decorationBlockEntity, boolean dropItem) {
        ObjectListIterator objectListIterator = this.seatConfig.iterator();
        while (objectListIterator.hasNext()) {
            SeatMeta seatMeta = (SeatMeta)objectListIterator.next();
            SeatEntity seat = this.getSeatEntity(decorationBlockEntity, seatMeta);
            if (seat == null || seat.method_31483() == null) continue;
            seat.method_31483().method_5848();
        }
    }

    public static class SeatConfig
    extends ObjectArrayList<SeatMeta> {
    }

    public static class SeatMeta {
        public Vector3f offset = new Vector3f();
        public float direction = 180.0f;
    }
}

