/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import com.mojang.serialization.DynamicOps;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.block.SimpleBlockItem;
import de.tomalbrc.filament.decoration.DecorationItem;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.decoration.holder.DecorationHolder;
import de.tomalbrc.filament.util.Util;
import eu.pb4.polymer.virtualentity.api.elements.BlockDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7833;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Showcase
implements DecorationBehaviour<ShowcaseConfig> {
    private static final String SHOWCASE_KEY = "Showcase";
    private static final String ITEM = "Item";
    private final ShowcaseConfig config;
    Object2ObjectOpenHashMap<ShowcaseMeta, DisplayElement> showcases = new Object2ObjectOpenHashMap();

    public Showcase(ShowcaseConfig config) {
        this.config = config;
    }

    @Override
    @NotNull
    public ShowcaseConfig getConfig() {
        return this.config;
    }

    @Override
    public class_1269 interact(class_3222 player, class_1268 hand, class_243 location, DecorationBlockEntity decorationBlockEntity) {
        if (!player.method_21823() && decorationBlockEntity.getDecorationHolder() instanceof DecorationHolder) {
            ShowcaseMeta showcase = this.getClosestShowcase(decorationBlockEntity, location);
            class_1799 itemStack = player.method_5998(hand);
            class_1799 showcaseStack = this.getShowcaseItemStack(showcase);
            if (this.canUseShowcaseItem(showcase, itemStack)) {
                boolean changed = false;
                if (!player.method_5998(hand).method_7960()) {
                    changed = true;
                    if (showcaseStack != null && !showcaseStack.method_7960()) {
                        Util.spawnAtLocation(decorationBlockEntity.method_10997(), location, showcaseStack);
                    }
                    this.setShowcaseItemStack(decorationBlockEntity, showcase, itemStack.method_46651(1));
                    itemStack.method_7934(1);
                    player.method_37908().method_43128(null, location.method_10216(), location.method_10214(), location.method_10215(), class_3414.method_47908((class_2960)showcase.addItemSound), class_3419.field_15254, 1.0f, 1.0f);
                } else if (showcaseStack != null && !showcaseStack.method_7960()) {
                    changed = true;
                    player.method_6122(hand, showcaseStack);
                    this.setShowcaseItemStack(decorationBlockEntity, showcase, class_1799.field_8037);
                    player.method_37908().method_43128(null, location.method_10216(), location.method_10214(), location.method_10215(), class_3414.method_47908((class_2960)showcase.removeItemSound), class_3419.field_15254, 1.0f, 1.0f);
                }
                if (changed) {
                    decorationBlockEntity.method_5431();
                    return class_1269.field_21466;
                }
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public void read(class_2487 compoundTag, class_7225.class_7874 provider, DecorationBlockEntity blockEntity) {
        if (compoundTag.method_10545(SHOWCASE_KEY) && blockEntity.getOrCreateHolder() != null) {
            class_2487 showcaseTag = (class_2487)compoundTag.method_10562(SHOWCASE_KEY).orElseThrow();
            DecorationHolder holder = (DecorationHolder)blockEntity.getDecorationHolder();
            if (holder == null) {
                return;
            }
            if (blockEntity.has(Behaviours.SHOWCASE)) {
                Showcase showcase = (Showcase)blockEntity.get(Behaviours.SHOWCASE);
                assert (showcase != null);
                for (int i = 0; i < showcase.config.size(); ++i) {
                    ShowcaseMeta showcaseMeta = (ShowcaseMeta)showcase.config.get(i);
                    String key = ITEM + i;
                    if (!showcaseTag.method_10545(key)) continue;
                    class_6903 registryOps = provider.method_57093((DynamicOps)class_2509.field_11560);
                    this.setShowcaseItemStack(blockEntity, showcaseMeta, (class_1799)showcaseTag.method_67492(key, class_1799.field_24671, (DynamicOps)registryOps).orElseThrow());
                }
            }
        }
    }

    @Override
    public void write(class_2487 compoundTag, class_7225.class_7874 provider, DecorationBlockEntity blockEntity) {
        if (blockEntity.getDecorationHolder() != null) {
            class_2487 showcaseTag = new class_2487();
            for (int i = 0; i < this.config.size(); ++i) {
                ShowcaseMeta showcase = (ShowcaseMeta)this.config.get(i);
                if (showcase == null || this.getShowcaseItemStack(showcase).method_7960()) continue;
                showcaseTag.method_10566(ITEM + i, this.getShowcaseItemStack(showcase).method_57358(provider));
            }
            compoundTag.method_10566(SHOWCASE_KEY, (class_2520)showcaseTag);
        }
    }

    @Override
    public void destroy(DecorationBlockEntity decorationBlockEntity, boolean dropItem) {
        if (decorationBlockEntity.getDecorationHolder() instanceof DecorationHolder) {
            this.config.forEach(showcase -> {
                class_1799 itemStack = this.getShowcaseItemStack((ShowcaseMeta)showcase);
                if (itemStack != null && !itemStack.method_7960()) {
                    Util.spawnAtLocation(decorationBlockEntity.method_10997(), decorationBlockEntity.method_11016().method_46558(), itemStack.method_51164());
                }
            });
        }
    }

    public ShowcaseMeta getClosestShowcase(DecorationBlockEntity decorationBlockEntity, class_243 location) {
        if (this.config.size() == 1) {
            return (ShowcaseMeta)this.config.getFirst();
        }
        double dist = Double.MAX_VALUE;
        ShowcaseMeta nearest = null;
        ObjectListIterator objectListIterator = this.config.iterator();
        while (objectListIterator.hasNext()) {
            ShowcaseMeta showcase = (ShowcaseMeta)objectListIterator.next();
            class_243 q = decorationBlockEntity.method_11016().method_46558().method_1019(new class_243(this.showcaseTranslation(decorationBlockEntity, showcase)));
            double distance = q.method_1022(location);
            if (!(distance < dist)) continue;
            dist = distance;
            nearest = showcase;
        }
        return nearest;
    }

    private Vector3f showcaseTranslation(DecorationBlockEntity decorationBlockEntity, ShowcaseMeta showcase) {
        return new Vector3f((Vector3fc)showcase.offset).sub(0.0f, 0.475f, 0.0f).rotate((Quaternionfc)class_7833.field_40715.rotation((float)Math.PI / 180 * decorationBlockEntity.getVisualRotationYInDegrees()));
    }

    /*
     * Unable to fully structure code
     */
    public void setShowcaseItemStack(DecorationBlockEntity decorationBlockEntity, ShowcaseMeta showcase, class_1799 itemStack) {
        block6: {
            block5: {
                if (!Showcase.$assertionsDisabled && decorationBlockEntity.getDecorationHolder() == null) {
                    throw new AssertionError();
                }
                isBlockItem = itemStack.method_7909() instanceof class_1747;
                element = (DisplayElement)this.showcases.get((Object)showcase);
                v0 = dynNeedsUpdate = showcase.type == ShowcaseType.dynamic && element != null && (element instanceof BlockDisplayElement == false || isBlockItem == false);
                if (element != null && !dynNeedsUpdate) break block5;
                if (element != null) {
                    decorationBlockEntity.getDecorationHolder().removeElement((VirtualElement)element);
                    this.showcases.remove((Object)showcase);
                }
                newElement = this.createShowcase(decorationBlockEntity, showcase, itemStack);
                decorationBlockEntity.getDecorationHolder().addElement((VirtualElement)newElement);
                break block6;
            }
            if (!(element instanceof BlockDisplayElement)) ** GOTO lbl-1000
            blockDisplayElement = (BlockDisplayElement)element;
            var11_9 = itemStack.method_7909();
            if (var11_9 instanceof class_1747 && !((blockItem = (class_1747)var11_9) instanceof SimpleBlockItem)) {
                blockDisplayElement.setBlockState(blockItem.method_7711().method_9564());
            } else if (element instanceof ItemDisplayElement) {
                itemDisplayElement = (ItemDisplayElement)element;
                itemDisplayElement.setItem(itemStack);
            }
        }
        decorationBlockEntity.getDecorationHolder().tick();
    }

    private BlockDisplayElement element(class_1747 blockItem) {
        BlockDisplayElement displayElement = new BlockDisplayElement();
        displayElement.setBlockState(blockItem.method_7711().method_9564());
        return displayElement;
    }

    private ItemDisplayElement element(class_1799 itemStack) {
        ItemDisplayElement displayElement = new ItemDisplayElement();
        displayElement.setItem(itemStack.method_7972());
        return displayElement;
    }

    private DisplayElement createShowcase(DecorationBlockEntity decorationBlockEntity, ShowcaseMeta showcase, class_1799 itemStack) {
        Object element = null;
        switch (showcase.type.ordinal()) {
            case 0: {
                element = this.element(itemStack);
                break;
            }
            case 1: {
                class_1747 blockItem;
                class_1792 class_17922 = itemStack.method_7909().method_8389();
                if (!(class_17922 instanceof class_1747) || (blockItem = (class_1747)class_17922) instanceof DecorationItem) break;
                element = this.element(blockItem);
                break;
            }
            case 2: {
                class_1747 blockItem;
                class_1792 class_17923 = itemStack.method_7909().method_8389();
                element = class_17923 instanceof class_1747 && !((blockItem = (class_1747)class_17923) instanceof DecorationItem) ? this.element(blockItem) : this.element(itemStack);
            }
        }
        if (element != null) {
            element.setScale((Vector3fc)showcase.scale);
            element.setLeftRotation((Quaternionfc)showcase.rotation);
            Quaternionf rot = class_7833.field_40715.rotationDegrees(decorationBlockEntity.getVisualRotationYInDegrees() + 180.0f).normalize();
            if (element instanceof BlockDisplayElement) {
                element.setTranslation((Vector3fc)this.showcaseTranslation(decorationBlockEntity, showcase).add((Vector3fc)new Vector3f(-0.5f, -0.5f, -0.5f).rotate((Quaternionfc)rot).mul((Vector3fc)showcase.scale)));
            } else {
                element.setTranslation((Vector3fc)this.showcaseTranslation(decorationBlockEntity, showcase));
            }
            element.setRightRotation((Quaternionfc)rot);
            this.showcases.put((Object)showcase, element);
        } else {
            Filament.LOGGER.error("In valid showcase type for " + itemStack.method_7909().method_7876());
        }
        return element;
    }

    public class_1799 getShowcaseItemStack(ShowcaseMeta showcase) {
        DisplayElement element = (DisplayElement)this.showcases.get((Object)showcase);
        if (element instanceof ItemDisplayElement) {
            ItemDisplayElement itemDisplayElement = (ItemDisplayElement)element;
            return itemDisplayElement.getItem().method_7972();
        }
        if (element instanceof BlockDisplayElement) {
            BlockDisplayElement itemDisplayElement = (BlockDisplayElement)element;
            return itemDisplayElement.getBlockState().method_26204().method_8389().method_7854();
        }
        return class_1799.field_8037;
    }

    public boolean canUseShowcaseItem(ShowcaseMeta showcase, class_1799 item) {
        boolean hasFilterTags;
        boolean hasFilterItems = showcase.filterItems != null && !showcase.filterItems.isEmpty();
        boolean bl = hasFilterTags = showcase.filterTags != null && !showcase.filterTags.isEmpty();
        if (hasFilterTags) {
            for (class_2960 class_29602 : showcase.filterTags) {
                class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_29602);
                if (!item.method_31573(key)) continue;
                return true;
            }
        }
        if (hasFilterItems) {
            for (class_1792 class_17922 : showcase.filterItems) {
                if (!item.method_31574(class_17922)) continue;
                return true;
            }
        }
        return !hasFilterItems && !hasFilterTags;
    }

    public static class ShowcaseConfig
    extends ObjectArrayList<ShowcaseMeta> {
    }

    public static class ShowcaseMeta {
        public Vector3f offset = new Vector3f();
        public Vector3f scale = new Vector3f(1.0f);
        public Quaternionf rotation = new Quaternionf();
        public ShowcaseType type = ShowcaseType.item;
        public List<class_1792> filterItems;
        public List<class_2960> filterTags;
        public class_2960 addItemSound = class_3417.field_14667.comp_3319();
        public class_2960 removeItemSound = class_3417.field_14770.comp_3319();
    }

    public static enum ShowcaseType {
        item,
        block,
        dynamic;

    }
}

