/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.entity.goal;

import de.tomalbrc.filament.api.behaviour.EntityBehaviour;
import de.tomalbrc.filament.entity.FilamentMob;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3218;
import net.minecraft.class_4051;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreedGoal
implements EntityBehaviour<Config> {
    private final Config config;

    public BreedGoal(Config config) {
        this.config = config;
    }

    @Override
    public void registerGoals(FilamentMob mob) {
        EntityBehaviour.super.registerGoals(mob);
        mob.getGoalSelector().method_6277(this.config.priority, (class_1352)new BreedGoalImpl(this, mob, this.config.speedModifier));
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public static class Config {
        int priority;
        float speedModifier = 1.0f;
    }

    public class BreedGoalImpl
    extends class_1352 {
        private static final class_4051 PARTNER_TARGETING = class_4051.method_36626().method_18418(8.0).method_36627();
        protected final FilamentMob animal;
        protected final class_3218 level;
        @Nullable
        protected FilamentMob partner;
        private int loveTime;
        private final double speedModifier;

        public BreedGoalImpl(BreedGoal this$0, FilamentMob filamentMob, double d) {
            this.animal = filamentMob;
            this.level = BreedGoalImpl.method_64451((class_1297)filamentMob);
            this.speedModifier = d;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (!this.animal.method_6479()) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partner != null;
        }

        public boolean method_6266() {
            return this.partner.method_5805() && this.partner.method_6479() && this.loveTime < 60 && !this.partner.method_52546();
        }

        public void method_6270() {
            this.partner = null;
            this.loveTime = 0;
        }

        public void method_6268() {
            this.animal.method_5988().method_6226((class_1297)this.partner, 10.0f, (float)this.animal.method_5978());
            this.animal.method_5942().method_6335((class_1297)this.partner, this.speedModifier);
            ++this.loveTime;
            if (this.loveTime >= this.method_38847(60) && this.animal.method_5858((class_1297)this.partner) < 9.0) {
                this.breed();
            }
        }

        @Nullable
        private FilamentMob getFreePartner() {
            List list = this.level.method_64392(FilamentMob.class, PARTNER_TARGETING, (class_1309)this.animal, this.animal.method_5829().method_1014(8.0));
            double dist = Double.MAX_VALUE;
            FilamentMob mob = null;
            for (FilamentMob mob2 : list) {
                if (!this.animal.method_6474(mob2) || mob2.method_52546() || !(this.animal.method_5858((class_1297)mob2) < dist)) continue;
                mob = mob2;
                dist = this.animal.method_5858((class_1297)mob2);
            }
            return mob;
        }

        protected void breed() {
            this.animal.method_24650(this.level, this.partner);
        }
    }
}

