/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.BlockBehaviourWithEntity;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.data.resource.BlockResource;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.data.resource.ResourceProvider;
import de.tomalbrc.filament.util.FilamentBlockResourceUtils;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockData
extends Data {
    @NotNull
    private final BlockResource blockResource;
    @Nullable
    private final BlockStateMappedProperty<BlockModelType> blockModelType;
    @Nullable
    private final BlockProperties properties;
    @Nullable
    private final Set<class_2960> blockTags;
    private final boolean virtual;
    @Nullable
    private final class_2680 block;

    public BlockData(@NotNull class_2960 id, @Nullable class_1792 vanillaItem, @Nullable Map<String, String> translations, @Nullable ItemResource itemResource, @Nullable class_2960 itemModel, @Nullable BehaviourConfigMap behaviourConfig, @Nullable class_9323 components, @Nullable class_2960 itemGroup, @NotNull BlockResource blockResource, @Nullable BlockStateMappedProperty<BlockModelType> blockModelType, @Nullable BlockProperties properties, boolean virtual, @Nullable class_2680 block, @Nullable Set<class_2960> itemTags, @Nullable Set<class_2960> blockTags) {
        super(id, vanillaItem, translations, itemResource, itemModel, behaviourConfig, components, itemGroup, itemTags);
        this.blockResource = blockResource;
        this.blockModelType = blockModelType;
        this.properties = properties;
        this.blockTags = blockTags;
        this.virtual = virtual;
        this.block = block;
    }

    @Override
    @NotNull
    public BlockProperties properties() {
        if (this.properties == null) {
            return BlockProperties.EMPTY;
        }
        return this.properties;
    }

    public boolean requiresEntityBlock() {
        Boolean[] flag = new Boolean[]{false};
        this.behaviour().forEach((behaviourType, object) -> {
            if (BlockBehaviourWithEntity.class.isAssignableFrom(behaviourType.type())) {
                flag[0] = true;
            }
        });
        return flag[0];
    }

    public boolean virtual() {
        return this.virtual;
    }

    @Nullable
    public class_2680 block() {
        return this.block;
    }

    public Map<class_2680, BlockStateMeta> createStandardStateMap() {
        Reference2ReferenceArrayMap val = new Reference2ReferenceArrayMap();
        if (this.blockResource.models() != null && this.blockModelType != null) {
            for (Map.Entry<String, PolymerBlockModel> entry : this.blockResource.models().entrySet()) {
                if (entry.getKey().equals("default")) {
                    BlockModelType type = this.safeBlockModelType(this.blockModelType.getRawValue());
                    class_2680 requestedState = type == null ? null : FilamentBlockResourceUtils.requestBlock(type, entry.getValue(), this.virtual());
                    val.put((Object)((class_2248)class_7923.field_41175.method_63535(this.id)).method_9564(), (Object)BlockStateMeta.of(type == null ? class_2246.field_9987.method_9564() : requestedState, entry.getValue()));
                    continue;
                }
                class_2680 state = BlockData.blockState(String.format("%s[%s]", this.id, entry.getKey()));
                BlockModelType type = this.blockModelType.isMap() ? this.safeBlockModelType(this.blockModelType.getOrDefault(state, BlockModelType.FULL_BLOCK)) : this.safeBlockModelType(this.blockModelType.getRawValue());
                class_2680 requestedState = type == null ? null : FilamentBlockResourceUtils.requestBlock(type, entry.getValue(), this.virtual());
                val.put((Object)state, (Object)BlockStateMeta.of(type == null ? class_2246.field_9987.method_9564() : requestedState, entry.getValue()));
            }
        }
        return val;
    }

    private static class_2680 blockState(String str) {
        class_2259.class_7211 parsed;
        try {
            parsed = class_2259.method_41957((class_7225)class_7923.field_41175, (String)str, (boolean)false);
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Invalid BlockState value: " + str);
        }
        return parsed.comp_622();
    }

    private BlockModelType safeBlockModelType(BlockModelType blockModelType) {
        if (PolymerBlockResourceUtils.getBlocksLeft((BlockModelType)blockModelType) <= 0) {
            blockModelType = BlockModelType.FULL_BLOCK;
            if (PolymerBlockResourceUtils.getBlocksLeft((BlockModelType)blockModelType) <= 0) {
                Filament.LOGGER.error("Filament: Ran out of blockModelTypes to use AND FULL_BLOCK ran out too! Using Bedrock block temporarily. Fix your Block-Config for {}!", (Object)this.id());
                return null;
            }
            Filament.LOGGER.error("Filament: Ran out of blockModelTypes to use! Using FULL_BLOCK");
        }
        return blockModelType;
    }

    @NotNull
    public BlockResource blockResource() {
        return this.blockResource;
    }

    @Override
    @NotNull
    public ResourceProvider preferredResource() {
        return this.blockResource();
    }

    @Nullable
    public BlockStateMappedProperty<BlockModelType> blockModelType() {
        return this.blockModelType;
    }

    @Nullable
    public Set<class_2960> blockTags() {
        return this.blockTags;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlockData that = (BlockData)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "BlockData[id=" + String.valueOf(this.id) + ", vanillaItem=" + String.valueOf(this.vanillaItem) + ", blockResource=" + String.valueOf(this.blockResource) + ", itemResource=" + String.valueOf(this.itemResource) + ", blockModelType=" + String.valueOf(this.blockModelType) + ", properties=" + String.valueOf(this.properties) + ", behaviourConfig=" + String.valueOf(this.behaviour) + ", components=" + String.valueOf(this.components) + ", itemGroup=" + String.valueOf(this.group) + "]";
    }

    public record BlockStateMeta(class_2680 blockState, PolymerBlockModel polymerBlockModel) {
        public static BlockStateMeta of(class_2680 blockState, PolymerBlockModel blockModel) {
            return new BlockStateMeta(blockState, blockModel);
        }
    }
}

