/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data;

import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.data.properties.DecorationProperties;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.util.DecorationUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;

public final class DecorationData
extends Data {
    @Nullable
    private final List<BlockConfig> blocks;
    @Nullable
    private final Vector2f size;
    @Nullable
    private final DecorationProperties properties;
    @Nullable
    private final Set<class_2960> blockTags;
    @Nullable
    private final Boolean itemFrame;
    @Nullable
    private final class_2680 block;

    public DecorationData(@NotNull class_2960 id, @Nullable class_1792 vanillaItem, @Nullable Map<String, String> translations, @Nullable ItemResource itemResource, @Nullable class_2960 itemModel, @Nullable BehaviourConfigMap behaviourConfig, @Nullable class_9323 components, @Nullable class_2960 itemGroup, @Nullable Set<class_2960> itemTags, @Nullable Set<class_2960> blockTags, @Nullable DecorationProperties properties, @Nullable List<BlockConfig> blocks, @Nullable class_2680 block, @Nullable Vector2f size, @Nullable Boolean itemFrame) {
        super(id, vanillaItem, translations, itemResource, itemModel, behaviourConfig, components, itemGroup, itemTags);
        this.blocks = blocks;
        this.size = size;
        this.properties = properties;
        this.blockTags = blockTags;
        this.itemFrame = itemFrame;
        this.block = block;
    }

    @Override
    @NotNull
    public DecorationProperties properties() {
        if (this.properties == null) {
            return DecorationProperties.EMPTY;
        }
        return this.properties;
    }

    public boolean isContainer() {
        return this.behaviour().has(Behaviours.CONTAINER);
    }

    public boolean hasBlocks() {
        return this.blocks != null;
    }

    public int countBlocks() {
        if (!this.hasBlocks()) {
            return 0;
        }
        int c = 0;
        for (BlockConfig block : this.blocks) {
            c += (int)(block.size().x() * block.size().y() * block.size().z());
        }
        return c;
    }

    public boolean isSimple() {
        boolean singleBlock = !this.hasBlocks() || DecorationUtil.barrierDimensions(Objects.requireNonNull(this.blocks()), 0.0f).equals(1.0f, 1.0f);
        Boolean[] hasDecorationBehaviour = new Boolean[]{false};
        this.behaviour().forEach((a, b) -> {
            if (DecorationBehaviour.class.isAssignableFrom(a.type())) {
                hasDecorationBehaviour[0] = true;
            }
        });
        boolean canBeDyed = this.vanillaItem != null && (this.vanillaItem == class_1802.field_18138 || this.vanillaItem == class_1802.field_8450);
        boolean groundOnly = !this.properties().placement.wall() && !this.properties().placement.ceiling();
        return groundOnly && !canBeDyed && hasDecorationBehaviour[0] == false && (singleBlock || this.size != null);
    }

    @Nullable
    public List<BlockConfig> blocks() {
        return this.blocks;
    }

    @Nullable
    public Vector2f size() {
        return this.size;
    }

    @Nullable
    public Boolean itemFrame() {
        return this.itemFrame;
    }

    @NotNull
    public class_2680 block() {
        return this.block != null ? this.block : class_2246.field_10499.method_9564();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DecorationData that = (DecorationData)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "DecorationData[id=" + String.valueOf(this.id) + ", itemResource=" + String.valueOf(this.itemResource) + ", vanillaItem=" + String.valueOf(this.vanillaItem) + ", blocks=" + String.valueOf(this.blocks) + ", size=" + String.valueOf(this.size) + ", properties=" + String.valueOf(this.properties) + ", behaviourConfig=" + String.valueOf(this.behaviour) + ", components=" + String.valueOf(this.components) + ", itemGroup=" + String.valueOf(this.group) + "]";
    }

    public boolean isLightEnabled() {
        return this.properties().mayBeLightSource() || this.behaviour().has(Behaviours.LAMP);
    }

    public boolean hasLightBehaviours() {
        return this.behaviour().has(Behaviours.LAMP);
    }

    @Nullable
    public Set<class_2960> blockTags() {
        return this.blockTags;
    }

    public record BlockConfig(Vector3f origin, Vector3f size, class_2680 block) {
    }
}

