/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration;

import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.block.SimpleBlockItem;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.data.properties.DecorationProperties;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.decoration.block.SimpleDecorationBlock;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.util.DecorationUtil;
import de.tomalbrc.filament.util.Util;
import eu.pb4.polymer.core.api.item.PolymerItem;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class DecorationItem
extends SimpleBlockItem
implements PolymerItem,
BehaviourHolder {
    private final DecorationData decorationData;

    public DecorationItem(class_2248 block, DecorationData decorationData, class_1792.class_1793 properties) {
        super(properties, block, decorationData);
        this.initBehaviours(decorationData.behaviour());
        this.decorationData = decorationData;
    }

    public DecorationData getDecorationData() {
        return this.decorationData;
    }

    @Override
    public void method_67187(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        if (this.decorationData.vanillaItem().method_57347().method_57832(class_9334.field_49644) || this.decorationData.components().method_57832(class_9334.field_49644)) {
            consumer.accept((class_2561)class_2561.method_43470((String)"\u00a79Dyeable"));
        }
        super.method_67187(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
    }

    public static float getVisualRotationYInDegrees(class_2350 direction, int rotation) {
        int i = direction.method_10166().method_10178() ? 90 * direction.method_10171().method_10181() : 0;
        return class_3532.method_15392((int)(180 + direction.method_10161() * 90 + rotation * 45 + i));
    }

    @Override
    @NotNull
    public class_1269 method_7884(class_1838 useOnContext) {
        boolean propertyPlaceCheck;
        class_1269 res = super.method_7884(useOnContext);
        if (res.method_23665()) {
            return res;
        }
        if (this.decorationData == null) {
            Filament.LOGGER.warn("Can't use decoration Item: Missing decoration data!");
            return class_1269.field_5814;
        }
        DecorationProperties properties = this.decorationData.properties();
        boolean replaceable = useOnContext.method_8045().method_8320(useOnContext.method_8037()).method_45474();
        class_2338 blockPos = useOnContext.method_8037();
        class_2350 direction = replaceable ? class_2350.field_11036 : useOnContext.method_8038();
        class_2338 relativeBlockPos = replaceable ? blockPos : blockPos.method_10093(direction);
        class_1657 player = useOnContext.method_8036();
        class_1799 itemStack = useOnContext.method_8041();
        class_1937 level = useOnContext.method_8045();
        int rotation = 0;
        if (properties.rotate) {
            rotation = properties.rotateSmooth ? Util.SEGMENTED_ANGLE8.method_48125(useOnContext.method_8044() - 180.0f) : Util.SEGMENTED_ANGLE8.method_48124(useOnContext.method_8042().method_10153());
        }
        if (!(propertyPlaceCheck = properties.placement.canPlace(direction)) && properties.placement.floor() && !level.method_8320(relativeBlockPos.method_10093(class_2350.field_11033)).method_26215()) {
            direction = class_2350.field_11036;
            propertyPlaceCheck = properties.placement.canPlace(direction);
        }
        if (!propertyPlaceCheck && properties.placement.ceiling() && !level.method_8320(relativeBlockPos.method_10093(class_2350.field_11036)).method_26215()) {
            direction = class_2350.field_11033;
            propertyPlaceCheck = properties.placement.canPlace(direction);
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            rotation = 0;
        }
        float angle = DecorationItem.getVisualRotationYInDegrees(direction, rotation);
        if (player == null || !this.mayPlace(player, direction, itemStack, relativeBlockPos) || !propertyPlaceCheck) {
            return class_1269.field_5814;
        }
        if (this.canPlaceAt(level, relativeBlockPos, angle) && itemStack.method_7909() instanceof DecorationItem) {
            DecorationItem.place(itemStack, level, relativeBlockPos, direction, rotation);
            player.method_6019(useOnContext.method_20287());
            itemStack.method_7934(1);
            class_3414 placeSound = properties.blockBase.method_9564().method_26231().method_10598();
            level.method_8396(null, blockPos, placeSound, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_52422;
        }
        return class_1269.field_5814;
    }

    protected boolean mayPlace(class_1657 player, class_2350 direction, class_1799 itemStack, class_2338 blockPos) {
        return !player.method_37908().method_31606(blockPos) && player.method_7343(blockPos, direction, itemStack);
    }

    private boolean canPlaceAt(class_1937 level, class_2338 blockPos, float angle) {
        if (!level.method_8320(blockPos).method_45474()) {
            return false;
        }
        if (this.decorationData.hasBlocks()) {
            boolean[] canPlace = new boolean[]{true};
            DecorationUtil.forEachRotated(this.decorationData.blocks(), blockPos, angle, blockPos2 -> {
                if (!level.method_8320(blockPos2).method_45474()) {
                    canPlace[0] = false;
                }
            });
            return canPlace[0];
        }
        return true;
    }

    public static void place(class_1799 itemStack, class_1937 level, class_2338 blockPos, class_2350 direction, int rotation) {
        DecorationData decorationData;
        float angle = DecorationItem.getVisualRotationYInDegrees(direction, rotation);
        if (!(itemStack.method_7909() instanceof DecorationItem)) {
            Filament.LOGGER.error("Tried to place non-decoration item as decoration! Item: {}", (Object)class_7923.field_41178.method_10221((Object)itemStack.method_7909()));
        }
        if ((decorationData = ((DecorationItem)itemStack.method_7909()).decorationData).hasBlocks() && decorationData.countBlocks() == 0) {
            Filament.LOGGER.warn("Found block data with potentially invalid blocks for {} while trying to place", (Object)decorationData.id());
        }
        if (decorationData.hasBlocks()) {
            DecorationUtil.forEachRotated(decorationData.blocks(), blockPos, angle, blockPos2 -> {
                class_2586 patt0$temp;
                level.method_22352(blockPos2, false);
                class_2680 blockState = DecorationRegistry.getDecorationBlock(decorationData.id()).method_9564();
                if (decorationData.properties().mayBeLightSource()) {
                    blockState = (class_2680)blockState.method_11657((class_2769)DecorationBlock.LIGHT_LEVEL, (Comparable)((Integer)decorationData.properties().lightEmission.getValue(blockState)));
                }
                if (!decorationData.properties().waterloggable) {
                    blockState = (class_2680)blockState.method_11657((class_2769)DecorationBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
                } else {
                    class_3610 fluidState = level.method_8316(blockPos2);
                    if (fluidState.method_39360((class_3611)class_3612.field_15910) && fluidState.method_15771()) {
                        blockState = (class_2680)blockState.method_11657((class_2769)DecorationBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                    }
                }
                if (decorationData.isSimple()) {
                    blockState = (class_2680)blockState.method_11657((class_2769)SimpleDecorationBlock.ROTATION, (Comparable)Integer.valueOf((rotation + 4) % 8));
                }
                level.method_8501(blockPos2, blockState);
                if (!decorationData.isSimple() && (patt0$temp = level.method_8321(blockPos2)) instanceof DecorationBlockEntity) {
                    DecorationBlockEntity decorationBlockEntity = (DecorationBlockEntity)patt0$temp;
                    decorationBlockEntity.setMain(new class_2338((class_2382)blockPos2).method_10059((class_2382)blockPos));
                    decorationBlockEntity.setItem(itemStack.method_46651(1));
                    decorationBlockEntity.setRotation(rotation);
                    decorationBlockEntity.setDirection(direction);
                    decorationBlockEntity.setupBehaviour(decorationData);
                    decorationBlockEntity.attach((class_3218)level);
                }
            });
        } else {
            class_2586 class_25862;
            class_2680 blockState = DecorationRegistry.getDecorationBlock(decorationData.id()).method_9564();
            if (!decorationData.properties().waterloggable) {
                blockState = (class_2680)blockState.method_11657((class_2769)DecorationBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            } else {
                class_3610 fluidState = level.method_8316(blockPos);
                if (fluidState.method_39360((class_3611)class_3612.field_15910) && fluidState.method_15771()) {
                    blockState = (class_2680)blockState.method_11657((class_2769)DecorationBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
            }
            if (decorationData.properties().mayBeLightSource()) {
                blockState = (class_2680)blockState.method_11657((class_2769)DecorationBlock.LIGHT_LEVEL, (Comparable)((Integer)decorationData.properties().lightEmission.getValue(blockState)));
            }
            if (decorationData.isSimple()) {
                blockState = (class_2680)blockState.method_11657((class_2769)SimpleDecorationBlock.ROTATION, (Comparable)Integer.valueOf((rotation + 4) % 8));
            }
            level.method_8501(blockPos, blockState);
            if (!decorationData.isSimple() && (class_25862 = level.method_8321(blockPos)) instanceof DecorationBlockEntity) {
                DecorationBlockEntity decorationBlockEntity = (DecorationBlockEntity)class_25862;
                decorationBlockEntity.setMain(class_2338.field_10980);
                decorationBlockEntity.setItem(itemStack.method_46651(1));
                decorationBlockEntity.setRotation(rotation);
                decorationBlockEntity.setDirection(direction);
                decorationBlockEntity.setupBehaviour(decorationData);
                decorationBlockEntity.attach((class_3218)level);
            }
        }
    }
}

