/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.block;

import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.util.VirtualDestroyStage;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.virtualentity.api.BlockWithElementHolder;
import java.util.function.BiConsumer;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public abstract class DecorationBlock
extends class_2248
implements PolymerBlock,
BlockWithElementHolder,
class_3737,
VirtualDestroyStage.Marker {
    protected final class_2960 decorationId;
    public static final class_2758 LIGHT_LEVEL = class_2741.field_12538;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected final class_2689<class_2248, class_2680> stateDefinitionEx;

    public DecorationBlock(class_4970.class_2251 properties, class_2960 decorationId) {
        super(properties);
        this.decorationId = decorationId;
        class_2689.class_2690 builder = new class_2689.class_2690((Object)this);
        this.method_9515((class_2689.class_2690<class_2248, class_2680>)builder);
        this.stateDefinitionEx = builder.method_11668(class_2248::method_9564, class_2680::new);
        DecorationData data = this.getDecorationData();
        class_2680 state = (class_2680)this.stateDefinitionEx.method_11664();
        if (data.isLightEnabled()) {
            state = (class_2680)state.method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(!data.hasLightBehaviours() && data.properties().mayBeLightSource() && !data.properties().lightEmission.isMap() ? (Integer)data.properties().lightEmission.getRawValue() : 0));
        }
        if (data.properties().waterloggable) {
            state = (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        this.method_9590(state);
    }

    @NotNull
    public class_2689<class_2248, class_2680> method_9595() {
        return this.stateDefinitionEx;
    }

    public DecorationData getDecorationData() {
        return DecorationRegistry.getDecorationDefinition(this.decorationId);
    }

    public boolean forceLightUpdates(class_2680 blockState) {
        return blockState.method_28498((class_2769)LIGHT_LEVEL) && (Integer)blockState.method_11654((class_2769)LIGHT_LEVEL) > 0;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        if (this.decorationId == null) {
            return;
        }
        DecorationData data = this.getDecorationData();
        if (data != null) {
            if (data.isLightEnabled()) {
                builder.method_11667(new class_2769[]{LIGHT_LEVEL});
            }
            if (data.properties().waterloggable) {
                builder.method_11667(new class_2769[]{WATERLOGGED});
            }
        }
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext packetContext) {
        class_2680 defaultState;
        boolean passthrough;
        DecorationData decorationData = this.getDecorationData();
        boolean bl = passthrough = !decorationData.hasBlocks();
        class_2680 class_26802 = passthrough ? (state.method_28498((class_2769)WATERLOGGED) && ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564()) : (defaultState = decorationData.block());
        if (state.method_28498((class_2769)WATERLOGGED) && defaultState.method_28498((class_2769)WATERLOGGED) && ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && !passthrough) {
            defaultState = (class_2680)defaultState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return defaultState;
    }

    public void method_55124(class_2680 blockState, class_3218 level, class_2338 blockPos, class_1927 explosion, BiConsumer<class_1799, class_2338> biConsumer) {
        if (!blockState.method_26215()) {
            this.removeDecoration((class_1937)level, blockPos, null);
        }
    }

    @NotNull
    public class_2680 method_9576(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        class_2680 returnVal = super.method_9576(level, blockPos, blockState, player);
        this.removeDecoration(level, blockPos, player);
        return returnVal;
    }

    private void removeDecoration(class_1937 level, class_2338 blockPos, class_1657 player) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof DecorationBlockEntity) {
            DecorationBlockEntity decorationBlockEntity = (DecorationBlockEntity)blockEntity;
            decorationBlockEntity.destroyStructure(player == null || !player.method_68878());
        } else {
            level.method_22352(blockPos, false);
        }
    }

    @NotNull
    public class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        if (!this.getDecorationData().hasBlocks()) {
            return class_259.method_1073();
        }
        return super.method_9549(blockState, blockGetter, blockPos, collisionContext);
    }

    public boolean method_10310(@Nullable class_1309 player, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_3611 fluid) {
        DecorationData data;
        if (DecorationRegistry.isDecoration(blockState) && (data = ((DecorationBlock)blockState.method_26204()).getDecorationData()) != null && (data.properties().waterloggable || !data.properties().solid)) {
            return fluid == class_3612.field_15910 || fluid == class_3612.field_15909;
        }
        return false;
    }

    public boolean method_10311(class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState, class_3610 fluidState) {
        if (DecorationRegistry.isDecoration(blockState) && ((DecorationBlock)blockState.method_26204()).getDecorationData() != null) {
            DecorationData data = ((DecorationBlock)blockState.method_26204()).getDecorationData();
            if (data.properties().waterloggable) {
                return super.method_10311(levelAccessor, blockPos, blockState, fluidState);
            }
            return false;
        }
        return false;
    }

    @NotNull
    public class_3610 method_9545(class_2680 blockState) {
        return blockState.method_28498((class_2769)WATERLOGGED) && (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    @NotNull
    protected class_2680 method_9559(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        if (blockState.method_28498((class_2769)WATERLOGGED) && ((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        return super.method_9559(blockState, levelReader, scheduledTickAccess, blockPos, direction, blockPos2, blockState2, randomSource);
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_3610 fluidState = blockPlaceContext.method_8045().method_8316(blockPlaceContext.method_8037());
        boolean bl = fluidState.method_15771() && fluidState.method_15772() == class_3612.field_15910;
        class_2680 res = super.method_9605(blockPlaceContext);
        assert (res != null);
        return res.method_28498((class_2769)WATERLOGGED) ? (class_2680)res.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(bl)) : res;
    }
}

