/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.block.entity;

import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.registry.DecorationRegistry;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public abstract class AbstractDecorationBlockEntity
extends class_2586 {
    public static final String MAIN = "Main";
    public static final String VERSION = "V";
    public static final String ITEM = "Item";
    public static final String ROTATION = "Rotation";
    public static final String DIRECTION = "Direction";
    protected class_2338 main;
    protected int version = 1;
    protected int rotation;
    protected class_2350 direction = class_2350.field_11036;
    protected class_1799 itemStack;

    public AbstractDecorationBlockEntity(class_2338 pos, class_2680 state) {
        super(DecorationRegistry.getBlockEntityType(state), pos, state);
    }

    public boolean isMain() {
        return this.main != null && this.main.equals((Object)class_2338.field_10980);
    }

    public void setMain(class_2338 main) {
        this.main = main;
    }

    public DecorationBlockEntity getMainBlockEntity() {
        assert (this.field_11863 != null);
        return (DecorationBlockEntity)this.field_11863.method_8321(new class_2338((class_2382)this.field_11867).method_10059((class_2382)this.main));
    }

    public class_2338 mainPosition() {
        return new class_2338((class_2382)this.field_11867).method_10059((class_2382)this.main);
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        if (!compoundTag.method_10545(VERSION)) {
            this.version = 1;
            if (compoundTag.method_10545(MAIN)) {
                Optional optional = compoundTag.method_67491(MAIN, class_2338.field_25064);
                this.main = optional.orElse(this.main).method_10059((class_2382)this.field_11867);
            }
        } else {
            this.version = compoundTag.method_10550(VERSION).orElse(1);
            if (compoundTag.method_10545(MAIN)) {
                Optional optional = compoundTag.method_67491(MAIN, class_2338.field_25064);
                this.main = optional.orElse(this.main);
            }
        }
        if (compoundTag.method_10545(ITEM)) {
            this.itemStack = (class_1799)class_1799.method_57360((class_7225.class_7874)provider, (class_2520)((class_2520)compoundTag.method_10562(ITEM).orElseThrow())).orElseThrow();
        }
        if (this.itemStack == null || this.itemStack.method_7960()) {
            this.itemStack = ((class_1792)class_7923.field_41178.method_63535(((DecorationBlock)this.method_11010().method_26204()).getDecorationData().id())).method_7854();
        }
        if (!this.isMain()) {
            return;
        }
        if (compoundTag.method_10545(ROTATION)) {
            this.rotation = compoundTag.method_68083(ROTATION, 0);
        }
        if (compoundTag.method_10545(DIRECTION)) {
            this.direction = class_2350.method_10143((int)compoundTag.method_68083(DIRECTION, class_2350.field_11036.method_10146()));
        }
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        if (this.itemStack == null) {
            Optional optionalKey = this.method_11010().method_41520().method_40230();
            Optional optional = class_7923.field_41178.method_10223(((class_5321)optionalKey.orElseThrow()).method_29177());
            optional.ifPresent(item -> {
                this.itemStack = ((class_1792)item.comp_349()).method_7854();
            });
        }
        if (this.itemStack == null && this.field_11863 != null) {
            Filament.LOGGER.error("No item for decoration! Removing decoration block entity at {}", (Object)this.method_11016().method_23854());
            this.field_11863.method_22352(this.method_11016(), false);
            this.method_11012();
            return;
        }
        if (this.itemStack != null) {
            compoundTag.method_10566(ITEM, this.itemStack.method_57358(provider));
        }
        if (this.main == null) {
            this.main = class_2338.field_10980;
        }
        compoundTag.method_67494(MAIN, class_2338.field_25064, (Object)this.main);
        compoundTag.method_10569(VERSION, this.version);
        if (this.isMain()) {
            compoundTag.method_10569(ROTATION, this.rotation);
            compoundTag.method_10569(DIRECTION, this.direction.method_10146());
        }
    }

    protected abstract void destroyBlocks(class_1799 var1);

    protected abstract void destroyStructure(boolean var1);

    public class_2350 getDirection() {
        return this.direction;
    }

    public void setDirection(class_2350 direction) {
        this.direction = direction;
    }

    public class_1799 getItem() {
        return this.itemStack;
    }

    public void setItem(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    public float getVisualRotationYInDegrees() {
        class_2350 direction = this.getDirection();
        int i = direction.method_10166().method_10178() ? 90 * direction.method_10171().method_10181() : 0;
        return class_3532.method_15392((int)(180 + direction.method_10161() * 90 + this.rotation * 45 + i));
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }
}

