/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.block.entity;

import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.BehaviourMap;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.decoration.block.entity.AbstractDecorationBlockEntity;
import de.tomalbrc.filament.decoration.holder.DecorationHolder;
import de.tomalbrc.filament.decoration.util.BlockEntityWithElementHolder;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.util.DecorationUtil;
import de.tomalbrc.filament.util.FilamentConfig;
import de.tomalbrc.filament.util.Util;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class DecorationBlockEntity
extends AbstractDecorationBlockEntity
implements BlockEntityWithElementHolder,
BehaviourHolder {
    private final BehaviourMap behaviours = new BehaviourMap();
    @Nullable
    private ElementHolder decorationHolder;

    public DecorationBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state);
    }

    @Override
    public BehaviourMap getBehaviours() {
        return this.behaviours;
    }

    @Override
    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        if (this.isMain()) {
            this.loadMain(compoundTag, provider);
        }
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (this.isMain() && level != null && this.decorationHolder == null) {
            if (this.behaviours.isEmpty() && !this.getDecorationData().behaviour().isEmpty()) {
                this.initBehaviours(this.getDecorationData().behaviour());
            }
            this.getOrCreateHolder();
        }
    }

    public void loadMain(class_2487 compoundTag, class_7225.class_7874 provider) {
        DecorationData decorationData = this.getDecorationData();
        if (decorationData == null) {
            Filament.LOGGER.error("No decoration data for {}!", (Object)this.itemStack.method_7909().method_7876());
        } else if (this.decorationHolder == null) {
            this.setupBehaviour(decorationData);
        }
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.behaviours) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour;
            decorationBehaviour.read(compoundTag, provider, this);
        }
    }

    @Override
    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.behaviours) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour;
            decorationBehaviour.write(compoundTag, provider, this);
        }
    }

    @Override
    public ElementHolder getOrCreateHolder() {
        DecorationBehaviour decorationBehaviour;
        Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry;
        Behaviour<?> behaviour;
        if (this.decorationHolder != null) {
            return this.decorationHolder;
        }
        DecorationHolder altHolder = null;
        Iterator<Map.Entry<BehaviourType<?, ?>, Behaviour<?>>> iterator = this.behaviours.iterator();
        while (iterator.hasNext() && (!((behaviour = (entry = iterator.next()).getValue()) instanceof DecorationBehaviour) || (altHolder = (decorationBehaviour = (DecorationBehaviour)behaviour).createHolder(this)) == null)) {
        }
        if (altHolder == null) {
            altHolder = new DecorationHolder(this);
        }
        this.decorationHolder = altHolder;
        return this.decorationHolder;
    }

    @Override
    @Nullable
    public ElementHolder getDecorationHolder() {
        return this.decorationHolder;
    }

    @Override
    public void setDecorationHolder(@Nullable ElementHolder holder) {
        this.decorationHolder = holder;
    }

    @Override
    public void attach(class_2818 chunk) {
        ElementHolder elementHolder;
        if (this.isMain() && this.itemStack != null && (elementHolder = this.getOrCreateHolder()).getAttachment() == null) {
            new BlockBoundAttachment(elementHolder, chunk, this.method_11010(), this.method_11016(), this.method_11016().method_46558(), !(this.getDecorationHolder() instanceof DecorationHolder));
        }
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviourEntry : this.behaviours) {
            Behaviour<?> behaviour = behaviourEntry.getValue();
            if (!(behaviour instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour;
            decorationBehaviour.onElementAttach(this, this.decorationHolder);
        }
    }

    @Override
    public void attach(class_3218 level) {
        this.attach((class_2818)level.method_22350(this.method_11016()));
    }

    public void setupBehaviour(DecorationData decorationData) {
        if (this.isMain() && this.behaviours.isEmpty()) {
            this.initBehaviours(decorationData.behaviour());
        }
    }

    @Override
    public void initBehaviours(BehaviourConfigMap behaviourConfigMap) {
        BehaviourHolder.super.initBehaviours(behaviourConfigMap);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
            decorationBehaviour.init(this);
        }
    }

    public class_1269 interact(class_1657 player, class_1268 interactionHand, class_243 location) {
        return this.decorationInteract((class_3222)player, interactionHand, location);
    }

    public class_1269 decorationInteract(class_3222 player, class_1268 interactionHand, class_243 location) {
        DecorationBehaviour decorationBehaviour;
        Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour;
        Behaviour<?> behaviour2;
        if (FilamentConfig.getInstance().preventAdventureModeDecorationInteraction && player.field_13974.method_14257() == class_1934.field_9216) {
            return class_1269.field_5811;
        }
        if (!this.isMain()) {
            return this.getMainBlockEntity().decorationInteract(player, interactionHand, location);
        }
        DecorationData decorationData = this.getDecorationData();
        if (decorationData == null) {
            Filament.LOGGER.warn("Can't interact with decoration: Missing decoration data! Location: {}", (Object)location.toString());
            return class_1269.field_5814;
        }
        class_1269.class_9859 res = class_1269.field_5811;
        Iterator<Map.Entry<BehaviourType<?, ?>, Behaviour<?>>> iterator = this.behaviours.iterator();
        while (!(!iterator.hasNext() || (behaviour2 = (behaviour = iterator.next()).getValue()) instanceof DecorationBehaviour && (res = (decorationBehaviour = (DecorationBehaviour)behaviour2).interact(player, interactionHand, location, this)).method_23665())) {
        }
        return res;
    }

    public class_1799 visualItemStack() {
        return DecorationUtil.placementAdjustedItem(this.itemStack, this.getDecorationData().itemResource(), this.direction != class_2350.field_11033 && this.direction != class_2350.field_11036, this.direction == class_2350.field_11033);
    }

    @Override
    protected void destroyBlocks(class_1799 particleItem) {
        class_2680 decorationBlockState = this.method_11010();
        if (DecorationRegistry.isDecoration(decorationBlockState) && this.getDecorationData() != null) {
            DecorationData data = this.getDecorationData();
            if (data.hasBlocks()) {
                DecorationUtil.forEachRotated(data.blocks(), this.method_11016(), this.getVisualRotationYInDegrees(), blockPos -> {
                    if (this.method_10997() != null && DecorationRegistry.isDecoration(this.method_10997().method_8320(blockPos))) {
                        if (data.properties().showBreakParticles) {
                            DecorationUtil.showBreakParticle((class_3218)this.field_11863, data.properties().useItemParticles ? particleItem : this.getDecorationData().properties().blockBase.method_8389().method_7854(), (float)blockPos.method_46558().method_10216(), (float)blockPos.method_46558().method_10214(), (float)blockPos.method_46558().method_10215());
                        }
                        this.method_10997().method_8650(blockPos, true);
                    }
                });
            } else {
                assert (this.field_11863 != null);
                class_2338 blockPos2 = this.method_11016();
                if (data.properties().showBreakParticles) {
                    DecorationUtil.showBreakParticle((class_3218)this.field_11863, this.getDecorationData().properties().useItemParticles ? particleItem : this.getDecorationData().properties().blockBase.method_8389().method_7854(), (float)blockPos2.method_46558().method_10216(), (float)blockPos2.method_46558().method_10214(), (float)blockPos2.method_46558().method_10215());
                }
                class_3414 breakSound = data.properties().blockBase.method_9564().method_26231().method_10595();
                this.field_11863.method_8396(null, this.method_11016(), breakSound, class_3419.field_15245, 1.0f, 1.0f);
                this.field_11863.method_22352(this.method_11016(), true);
            }
        }
    }

    @Override
    public void destroyStructure(boolean dropItem) {
        class_1799 thisItemStack;
        class_1799 visualStack = this.visualItemStack();
        if (!this.isMain()) {
            class_2586 class_25862;
            if (this.method_10997() != null && this.main != null && (class_25862 = this.method_10997().method_8321(this.method_11016().method_10059((class_2382)this.main))) instanceof DecorationBlockEntity) {
                DecorationBlockEntity mainBlockEntity = (DecorationBlockEntity)class_25862;
                mainBlockEntity.destroyStructure(dropItem);
            }
            return;
        }
        if (!this.getDecorationData().properties().drops) {
            dropItem = false;
        }
        if ((thisItemStack = this.getItem()) != null && !thisItemStack.method_7960()) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof DecorationBehaviour)) continue;
                DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
                if (dropItem) {
                    decorationBehaviour.modifyDrop(this, thisItemStack);
                }
                decorationBehaviour.destroy(this, dropItem);
            }
            if (dropItem) {
                Util.spawnAtLocation(this.method_10997(), this.method_11016().method_46558(), thisItemStack.method_7972());
            }
        }
        this.removeHolder(this.decorationHolder);
        this.destroyBlocks(visualStack);
    }

    private void removeHolder(ElementHolder holder) {
        if (holder != null && holder.getAttachment() != null) {
            holder.getAttachment().destroy();
        }
    }

    public DecorationData getDecorationData() {
        return ((DecorationBlock)this.method_11010().method_26204()).getDecorationData();
    }
}

