/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.holder;

import de.tomalbrc.bil.core.holder.positioned.PositionedHolder;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.decoration.Animation;
import de.tomalbrc.filament.behaviour.decoration.Container;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AnimatedHolder
extends PositionedHolder {
    private final DecorationBlockEntity decorationBlockEntity;

    public AnimatedHolder(DecorationBlockEntity blockEntity, Model model) {
        super((class_3218)blockEntity.method_10997(), blockEntity.method_11016().method_46558(), model);
        this.decorationBlockEntity = blockEntity;
        if (this.decorationBlockEntity.has(Behaviours.ANIMATION)) {
            Animation.AnimationConfig animation = this.decorationBlockEntity.getDecorationData().behaviour().get(Behaviours.ANIMATION);
            this.setAnimationData(animation);
        }
    }

    public void setRotation(float rotation) {
        this.getElements().forEach(x -> {
            if (x instanceof DisplayElement) {
                DisplayElement displayElement = (DisplayElement)x;
                displayElement.setTeleportDuration(0);
                displayElement.setYaw(rotation - 180.0f);
            }
        });
    }

    public void applyPose(Pose pose, DisplayWrapper display) {
        super.applyPose(pose, display);
        display.element().setTranslation((Vector3fc)pose.translation().get(new Vector3f()).sub(0.0f, 0.5f, 0.0f));
    }

    protected void onDataLoaded() {
        super.onDataLoaded();
        if (this.bones != null && this.decorationBlockEntity.getDecorationData() != null && this.decorationBlockEntity.getDecorationData().size() != null) {
            for (Bone bone : this.bones) {
                ((ItemDisplayElement)bone.element()).setDisplaySize(this.decorationBlockEntity.getDecorationData().size().get(0) * 1.5f, this.decorationBlockEntity.getDecorationData().size().get(1) * 1.5f);
            }
        }
    }

    public void setAnimationData(@NotNull Animation.AnimationConfig animationData) {
        if (animationData.model != null) {
            if (this.model == null) {
                Filament.LOGGER.error("No Animated model named '" + String.valueOf(animationData.model) + "' was found!");
            } else {
                if (animationData.autoplay != null) {
                    this.getAnimator().playAnimation(animationData.autoplay);
                }
                this.getElements().forEach(x -> {
                    if (x instanceof ItemDisplayElement) {
                        ItemDisplayElement itemDisplayElement = (ItemDisplayElement)x;
                        itemDisplayElement.setYaw(this.decorationBlockEntity.getVisualRotationYInDegrees());
                    }
                });
                if (this.decorationBlockEntity.has(Behaviours.CONTAINER)) {
                    Container container = (Container)this.decorationBlockEntity.get(Behaviours.CONTAINER);
                    assert (container != null);
                    if (container.getConfig().openAnimation != null) {
                        container.container.setOpenCallback(() -> {
                            ElementHolder patt0$temp = this.decorationBlockEntity.getDecorationHolder();
                            if (patt0$temp instanceof AnimatedHolder) {
                                AnimatedHolder animatedHolder = (AnimatedHolder)patt0$temp;
                                animatedHolder.getAnimator().playAnimation(container.getConfig().openAnimation, 2);
                            }
                        });
                    }
                    if (container.getConfig().closeAnimation != null) {
                        container.container.setCloseCallback(() -> {
                            ElementHolder patt0$temp = this.decorationBlockEntity.getDecorationHolder();
                            if (patt0$temp instanceof AnimatedHolder) {
                                AnimatedHolder animatedHolder = (AnimatedHolder)patt0$temp;
                                animatedHolder.getAnimator().playAnimation(container.getConfig().closeAnimation, 2);
                            }
                        });
                    }
                }
            }
        }
    }
}

