/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.holder;

import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.decoration.util.ItemFrameElement;
import de.tomalbrc.filament.util.DecorationUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_243;

public class DecorationHolder
extends ElementHolder {
    private final DecorationBlockEntity parent;

    public DecorationHolder(DecorationBlockEntity blockEntity) {
        this.parent = blockEntity;
        this.setup(blockEntity);
    }

    private void setup(DecorationBlockEntity blockEntity) {
        if (blockEntity.getDecorationData().hasBlocks()) {
            this.addElement(DecorationUtil.decorationItemDisplay(this.parent));
        } else if (blockEntity.getDecorationData().size() != null) {
            this.addElement(DecorationUtil.decorationItemDisplay(this.parent));
            this.addElement(DecorationUtil.decorationInteraction(this.parent));
        } else if (blockEntity.getDecorationData().itemFrame() == Boolean.TRUE) {
            ItemFrameElement itemFrameElement = new ItemFrameElement(this.parent);
            this.addElement(itemFrameElement);
        } else {
            this.addElement(DecorationUtil.decorationItemDisplay(this.parent));
            this.addElement(DecorationUtil.decorationInteraction(this.parent));
        }
    }

    public <T extends VirtualElement> T addElement(T element) {
        VirtualElement res = super.addElement(element);
        if (element instanceof InteractionElement) {
            InteractionElement interactionElement = (InteractionElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.put(interactionElement.getEntityId(), (Object)this.parent.getItem());
        }
        if (element instanceof ItemFrameElement) {
            ItemFrameElement itemFrameElement = (ItemFrameElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.put(itemFrameElement.getEntityId(), (Object)this.parent.getItem());
        }
        return (T)res;
    }

    protected void onAttachmentRemoved(HolderAttachment oldAttachment) {
        for (VirtualElement element : this.getElements()) {
            Object interactionElement;
            if (element instanceof InteractionElement) {
                interactionElement = (InteractionElement)element;
                DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.remove(interactionElement.getEntityId());
            }
            if (!(element instanceof ItemFrameElement)) continue;
            interactionElement = (ItemFrameElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.remove(interactionElement.getEntityId());
        }
    }

    protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
    }

    public class_243 getPos() {
        return this.getAttachment() != null ? this.getAttachment().getPos() : null;
    }
}

