/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.holder;

import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.decoration.block.SimpleDecorationBlock;
import de.tomalbrc.filament.decoration.util.ItemFrameElement;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.util.DecorationUtil;
import de.tomalbrc.filament.util.Util;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class SimpleDecorationHolder
extends ElementHolder {
    private ItemDisplayElement displayElement;

    protected void updateInitialPosition() {
        super.updateInitialPosition();
        HolderAttachment holderAttachment = this.getAttachment();
        if (holderAttachment instanceof ChunkAttachment) {
            ChunkAttachment chunkAttachment = (ChunkAttachment)holderAttachment;
            this.setBlock(chunkAttachment.getChunk().method_8320(class_2338.method_49638((class_2374)chunkAttachment.getPos())));
        }
    }

    public void setBlock(class_2680 blockState) {
        if (DecorationRegistry.isDecoration(blockState) && this.displayElement == null) {
            SimpleDecorationBlock decorationBlock = (SimpleDecorationBlock)blockState.method_26204();
            DecorationData data = decorationBlock.getDecorationData();
            this.displayElement = DecorationUtil.decorationItemDisplay(data, class_2350.field_11036, Util.SEGMENTED_ANGLE8.method_48126(((Integer)blockState.method_11654((class_2769)SimpleDecorationBlock.ROTATION)).intValue()));
            this.addElement(this.displayElement);
            if (!data.hasBlocks()) {
                InteractionElement interactionElement = DecorationUtil.decorationInteraction(data);
                this.addElement(interactionElement);
            }
        }
    }

    public <T extends VirtualElement> T addElement(T element) {
        if (element instanceof InteractionElement) {
            InteractionElement interactionElement = (InteractionElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.put(interactionElement.getEntityId(), (Object)this.displayElement.getItem());
        }
        if (element instanceof ItemFrameElement) {
            ItemFrameElement itemFrameElement = (ItemFrameElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.put(itemFrameElement.getEntityId(), (Object)this.displayElement.getItem());
        }
        return (T)super.addElement(element);
    }

    protected void onAttachmentRemoved(HolderAttachment oldAttachment) {
        for (VirtualElement element : this.getElements()) {
            Object interactionElement;
            if (element instanceof InteractionElement) {
                interactionElement = (InteractionElement)element;
                DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.remove(interactionElement.getEntityId());
            }
            if (!(element instanceof ItemFrameElement)) continue;
            interactionElement = (ItemFrameElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.remove(interactionElement.getEntityId());
        }
    }
}

