/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.item;

import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.block.SimpleBlockItem;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.item.FilamentItem;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FilamentItemDelegate {
    private final BehaviourHolder holder;

    public FilamentItemDelegate(BehaviourHolder holder) {
        this.holder = holder;
    }

    @Nullable
    public Data data() {
        Data data;
        BehaviourHolder behaviourHolder = this.holder;
        if (behaviourHolder instanceof FilamentItem) {
            FilamentItem filamentItem = (FilamentItem)behaviourHolder;
            data = filamentItem.getData();
        } else {
            behaviourHolder = this.holder;
            if (behaviourHolder instanceof SimpleBlockItem) {
                SimpleBlockItem blockItem = (SimpleBlockItem)behaviourHolder;
                data = blockItem.getData();
            } else {
                data = null;
            }
        }
        return data;
    }

    public void onUseTick(class_1937 level, class_1309 livingEntity, class_1799 itemStack, int i) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour)) continue;
            ItemBehaviour itemBehaviour = (ItemBehaviour)behaviour;
            itemBehaviour.onUseTick(level, livingEntity, itemStack, i);
        }
    }

    public boolean releaseUsing(class_1799 itemStack, class_1937 level, class_1309 livingEntity, int useDuration, Supplier<Boolean> fallback) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour) || !(itemBehaviour = (ItemBehaviour)behaviour).releaseUsing(itemStack, level, livingEntity, useDuration)) continue;
            return true;
        }
        return fallback.get();
    }

    public boolean useOnRelease(class_1799 itemStack, Supplier<Boolean> fallback) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour) || !(itemBehaviour = (ItemBehaviour)behaviour).useOnRelease(itemStack)) continue;
            return true;
        }
        return fallback.get();
    }

    public int getUseDuration(class_1799 itemStack, class_1309 livingEntity, Supplier<Integer> fallback) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            Optional<Integer> val;
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour) || !(val = (itemBehaviour = (ItemBehaviour)behaviour).getUseDuration(itemStack, livingEntity)).isPresent()) continue;
            return val.get();
        }
        return fallback.get();
    }

    public class_1839 getUseAnimation(class_1799 itemStack, Supplier<class_1839> fallback) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            class_1839 anim;
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour) || (anim = (itemBehaviour = (ItemBehaviour)behaviour).getUseAnimation(itemStack)) == class_1839.field_8952) continue;
            return anim;
        }
        return fallback.get();
    }

    public void hurtEnemy(class_1799 itemStack, class_1309 attacker, class_1309 target) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour)) continue;
            ItemBehaviour itemBehaviour = (ItemBehaviour)behaviour;
            itemBehaviour.hurtEnemy(itemStack, attacker, target);
        }
    }

    public void postHurtEnemy(class_1799 itemStack, class_1309 attacker, class_1309 target) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour)) continue;
            ItemBehaviour itemBehaviour = (ItemBehaviour)behaviour;
            itemBehaviour.postHurtEnemy(itemStack, attacker, target);
        }
        if (itemStack.method_57826(class_9334.field_50077)) {
            itemStack.method_7970(1, target, class_1304.field_6173);
        }
    }

    public void appendHoverText(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour)) continue;
            ItemBehaviour itemBehaviour = (ItemBehaviour)behaviour;
            itemBehaviour.appendHoverText(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        }
    }

    public void modifyPolymerItemStack(Map<String, class_2960> modelMap, class_1799 original, class_1799 polymer, class_1836 tooltipFlag, class_7225.class_7874 lookup, class_3222 player) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour)) continue;
            ItemBehaviour itemBehaviour = (ItemBehaviour)behaviour;
            itemBehaviour.modifyPolymerItemStack(modelMap, original, polymer, tooltipFlag, lookup, player);
        }
    }

    public class_1269 use(class_1792 item, class_1937 level, class_1657 player, class_1268 hand, Supplier<class_1269> fallback) {
        class_1269 result = fallback.get();
        if (result.method_23665()) {
            return result;
        }
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour) || !(result = (itemBehaviour = (ItemBehaviour)behaviour).use(item, level, player, hand)).method_23665()) continue;
            return result;
        }
        return result;
    }

    public class_1269 useOn(class_1838 context, Supplier<class_1269> fallback) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            class_1269 result;
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour) || !(result = (itemBehaviour = (ItemBehaviour)behaviour).useOn(context)).method_23665()) continue;
            return result;
        }
        return fallback.get();
    }

    public boolean mineBlock(class_1799 itemStack, class_1937 level, class_2680 state, class_2338 pos, class_1309 entity, Supplier<Boolean> fallback) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour) || !(itemBehaviour = (ItemBehaviour)behaviour).mineBlock(itemStack, level, state, pos, entity)) continue;
            return true;
        }
        return fallback.get();
    }

    public float getAttackDamageBonus(class_1297 entity, float base, class_1282 source, Supplier<Float> fallback) {
        float bonus = fallback.get().floatValue();
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour)) continue;
            ItemBehaviour itemBehaviour = (ItemBehaviour)behaviour;
            bonus += itemBehaviour.getAttackDamageBonus(entity, base, source);
        }
        return bonus;
    }

    public class_1282 getDamageSource(class_1309 livingEntity, Supplier<class_1282> fallback) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.holder.getBehaviours()) {
            ItemBehaviour itemBehaviour;
            class_1282 ds;
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof ItemBehaviour) || (ds = (itemBehaviour = (ItemBehaviour)behaviour).getDamageSource(livingEntity)) == null) continue;
            return ds;
        }
        return fallback.get();
    }
}

