/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.event.FilamentRegistrationEvents;
import de.tomalbrc.filament.behaviour.BehaviourUtil;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.decoration.Container;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.decoration.DecorationItem;
import de.tomalbrc.filament.decoration.block.ComplexDecorationBlock;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.decoration.block.SimpleDecorationBlock;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.registry.BlockRegistry;
import de.tomalbrc.filament.registry.EntityRegistry;
import de.tomalbrc.filament.registry.ItemRegistry;
import de.tomalbrc.filament.util.Constants;
import de.tomalbrc.filament.util.FilamentSynchronousResourceReloadListener;
import de.tomalbrc.filament.util.Json;
import de.tomalbrc.filament.util.RPUtil;
import de.tomalbrc.filament.util.Translations;
import de.tomalbrc.filament.util.Util;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_9282;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import org.jetbrains.annotations.NotNull;

public class DecorationRegistry {
    private static final Reference2ObjectOpenHashMap<class_2960, DecorationData> decorations = new Reference2ObjectOpenHashMap();
    private static final Reference2ObjectOpenHashMap<class_2960, class_2248> decorationBlocks = new Reference2ObjectOpenHashMap();
    private static final Reference2ObjectOpenHashMap<class_2248, class_2591<DecorationBlockEntity>> decorationBlockEntities = new Reference2ObjectOpenHashMap();
    public static int REGISTERED_BLOCK_ENTITIES = 0;
    public static int REGISTERED_DECORATIONS = 0;

    public static void register(InputStream inputStream) throws IOException {
        JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
        DecorationData data = (DecorationData)Json.GSON.fromJson(element, DecorationData.class);
        Util.handleComponentsCustom(element, data);
        DecorationRegistry.register(data);
    }

    public static void register(DecorationData data) {
        for (Map.Entry entry : decorations.entrySet()) {
            if (!((class_2960)entry.getKey()).equals((Object)data.id())) continue;
            return;
        }
        decorations.put((Object)data.id(), (Object)data);
        class_4970.class_2251 blockProperties = data.properties().toBlockProperties();
        class_2248 block = BlockRegistry.registerBlock(BlockRegistry.key(data.id()), DecorationRegistry.getBlockCreator(data), blockProperties, data.blockTags());
        decorationBlocks.put((Object)data.id(), (Object)block);
        class_1792.class_1793 properties = data.properties().toItemProperties();
        if (data.properties().copyComponents) {
            for (class_9336 component : data.vanillaItem().method_57347()) {
                properties.method_57349(component.comp_2443(), component.comp_2444());
            }
        }
        for (class_9336 component : data.components()) {
            properties.method_57349(component.comp_2443(), component.comp_2444());
        }
        if (data.isContainer()) {
            Container.ContainerConfig container = data.behaviour().get(Behaviours.CONTAINER);
            if (container.canPickup) {
                properties.method_57349(class_9334.field_49622, (Object)class_9288.field_49334);
            }
        }
        if (data.vanillaItem() == class_1802.field_18138 || data.vanillaItem() == class_1802.field_8450) {
            properties.method_57349(class_9334.field_49644, (Object)new class_9282(0xDAAD6D));
        }
        DecorationItem item = ItemRegistry.registerItem(ItemRegistry.key(data.id()), newProps -> new DecorationItem(block, data, (class_1792.class_1793)newProps), properties, data.group() != null ? data.group() : Constants.DECORATION_GROUP_ID, data.itemTags());
        BehaviourUtil.postInitItem((class_1792)item, item, data.behaviour());
        Translations.add((class_1792)item, block, data);
        RPUtil.create(item, data);
        ((FilamentRegistrationEvents.DecorationRegistration)FilamentRegistrationEvents.DECORATION.invoker()).registered(data, item, (DecorationBlock)block);
    }

    @NotNull
    private static Function<class_4970.class_2251, class_2248> getBlockCreator(DecorationData data) {
        Function<class_4970.class_2251, class_2248> gen = !data.isSimple() ? x -> {
            ComplexDecorationBlock block = new ComplexDecorationBlock(x.method_50012(class_3619.field_15972), data.id());
            class_2591 DECORATION_BLOCK_ENTITY = FabricBlockEntityTypeBuilder.create(DecorationBlockEntity::new, (class_2248[])new class_2248[]{block}).build();
            EntityRegistry.registerBlockEntity(EntityRegistry.key(data.id()), DECORATION_BLOCK_ENTITY);
            decorationBlockEntities.put((Object)block, (Object)DECORATION_BLOCK_ENTITY);
            ++REGISTERED_BLOCK_ENTITIES;
            return block;
        } : x -> new SimpleDecorationBlock((class_4970.class_2251)x, data.id());
        return gen;
    }

    public static DecorationData getDecorationDefinition(class_2960 resourceLocation) {
        return (DecorationData)decorations.get((Object)resourceLocation);
    }

    public static boolean isDecoration(class_2680 blockState) {
        return blockState.method_26204() instanceof DecorationBlock;
    }

    public static DecorationBlock getDecorationBlock(class_2960 resourceLocation) {
        return (DecorationBlock)decorationBlocks.get((Object)resourceLocation);
    }

    public static class_2591<DecorationBlockEntity> getBlockEntityType(class_2680 blockState) {
        return (class_2591)decorationBlockEntities.get((Object)blockState.method_26204());
    }

    public static class DecorationDataReloadListener
    implements FilamentSynchronousResourceReloadListener {
        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"filament", (String)"decorations");
        }

        public void method_14491(class_3300 resourceManager) {
            this.load("filament/decoration", null, resourceManager, (id, inputStream) -> {
                try {
                    DecorationRegistry.register(inputStream);
                }
                catch (IOException e) {
                    Filament.LOGGER.error("Failed to load decoration resource \"{}\".", id);
                }
            });
        }
    }
}

