/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.registry;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.event.FilamentRegistrationEvents;
import de.tomalbrc.filament.data.EntityData;
import de.tomalbrc.filament.decoration.util.SeatEntity;
import de.tomalbrc.filament.entity.AnimatedFilamentEnemyMob;
import de.tomalbrc.filament.entity.AnimatedFilamentMob;
import de.tomalbrc.filament.entity.FilamentEnemyMob;
import de.tomalbrc.filament.entity.FilamentMob;
import de.tomalbrc.filament.item.BaseProjectileEntity;
import de.tomalbrc.filament.item.TridentEntity;
import de.tomalbrc.filament.util.FilamentSynchronousResourceReloadListener;
import de.tomalbrc.filament.util.Json;
import de.tomalbrc.filament.util.Translations;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1208;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_155;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3551;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class EntityRegistry {
    public static Map<class_2960, Collection<class_2960>> ENTITY_TAGS = new Object2ReferenceOpenHashMap();
    private static final Reference2ObjectOpenHashMap<class_2960, EntityData> types = new Reference2ObjectOpenHashMap();
    public static final class_1299<BaseProjectileEntity> BASE_PROJECTILE = EntityRegistry.registerEntity("projectile", class_1299.class_1300.method_5903(BaseProjectileEntity::new, (class_1311)class_1311.field_17715).method_17687(0.5f, 0.5f).method_5901());
    public static final class_1299<TridentEntity> FILAMENT_TRIDENT = EntityRegistry.registerEntity("trident", class_1299.class_1300.method_5903(TridentEntity::new, (class_1311)class_1311.field_17715).method_17687(0.5f, 0.5f).method_55687(0.13f).method_5901());
    public static final class_1299<SeatEntity> SEAT_ENTITY = EntityRegistry.registerEntity("decoration_seat", class_1299.class_1300.method_5903(SeatEntity::new, (class_1311)class_1311.field_17715).method_5901().method_27300(20).method_17687(0.5f, 0.1f));

    public static void register(InputStream inputStream) throws IOException {
        JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
        EntityData data = (EntityData)Json.GSON.fromJson(element, EntityData.class);
        EntityRegistry.register(data);
    }

    public static void register(EntityData data) {
        ImmutableList size;
        if (class_7923.field_41177.method_10250(data.id())) {
            return;
        }
        types.put((Object)data.id(), (Object)data);
        Object object = size = data.properties().size == null || Objects.requireNonNull(data.properties().size).size() < 2 ? ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f)) : data.properties().size;
        assert (size != null);
        class_1299.class_1300 builder = data.animation() != null && data.animation().model() != null ? class_1299.class_1300.method_5903((class_1299.class_4049)(data.properties().forceEnemy ? AnimatedFilamentEnemyMob::new : AnimatedFilamentMob::new), (class_1311)data.properties().category).method_17687(((Float)size.getFirst()).floatValue(), ((Float)size.getLast()).floatValue()) : class_1299.class_1300.method_5903((class_1299.class_4049)(data.properties().forceEnemy ? FilamentEnemyMob::new : FilamentMob::new), (class_1311)data.properties().category).method_17687(((Float)size.getFirst()).floatValue(), ((Float)size.getLast()).floatValue());
        if (data.properties().fireImmune) {
            builder.method_19947();
        }
        if (data.properties().noSave) {
            builder.method_5904();
        }
        if (data.properties().noSummon) {
            builder.method_5901();
        }
        class_5132.class_5133 attributeBuilder = class_1308.method_26828();
        Map<class_2960, Double> attrMap = data.attributes();
        if (attrMap != null) {
            for (Map.Entry<class_2960, Double> entry : attrMap.entrySet()) {
                Optional attr = class_7923.field_41190.method_10223(entry.getKey());
                if (attr.isEmpty()) {
                    Filament.LOGGER.error("Invalid attribute id {} for entity {}", (Object)entry.getKey(), (Object)data.id());
                    continue;
                }
                attributeBuilder.method_26868((class_6880)attr.orElseThrow(), entry.getValue().doubleValue());
            }
        }
        class_1299 type = EntityRegistry.registerEntity(data.id(), builder);
        FabricDefaultAttributeRegistry.register((class_1299)type, (class_5132)attributeBuilder.method_26866());
        Translations.add(type, data);
        ENTITY_TAGS.put(data.id(), data.entityTags());
        if (data.spawn() != null) {
            data.spawn().add(type);
        }
        ((FilamentRegistrationEvents.EntityRegistration)FilamentRegistrationEvents.ENTITY.invoker()).registered(data, type);
    }

    public static EntityData getData(class_2960 resourceLocation) {
        return (EntityData)types.get((Object)resourceLocation);
    }

    public static void register() {
    }

    private static <T extends class_1297> class_1299 registerEntity(String str, class_1299.class_1300 type) {
        class_2960 id = class_2960.method_60655((String)"filament", (String)str);
        return EntityRegistry.registerEntity(id, type);
    }

    private static <T extends class_1297> class_1299 registerEntity(class_2960 id, class_1299.class_1300 type) {
        Map types = class_3551.method_15450().getSchema(DataFixUtils.makeKey((int)class_155.method_16673().method_37912().method_38494())).findChoiceType(class_1208.field_5729).types();
        types.put(id.toString(), (Type)types.get(class_7923.field_41177.method_10221((Object)class_1299.field_6051).toString()));
        class_1299 res = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)id, (Object)type.method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)id)));
        PolymerEntityUtils.registerType((class_1299[])new class_1299[]{res});
        return res;
    }

    public static class_5321<class_2591<?>> key(class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_41255, (class_2960)id);
    }

    public static void registerBlockEntity(class_5321<class_2591<?>> id, class_2591<?> type) {
        class_2378.method_39197((class_2378)class_7923.field_41181, id, type);
        PolymerBlockUtils.registerBlockEntity((class_2591[])new class_2591[]{type});
    }

    public static class EntityDataReloadListener
    implements FilamentSynchronousResourceReloadListener {
        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"filament", (String)"entities");
        }

        public void method_14491(class_3300 resourceManager) {
            this.load("filament/entity", null, resourceManager, (id, inputStream) -> {
                try {
                    EntityRegistry.register(inputStream);
                }
                catch (IOException e) {
                    Filament.LOGGER.error("Failed to load entity resource \"{}\".", id);
                }
            });
        }
    }
}

