/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.event.FilamentRegistrationEvents;
import de.tomalbrc.filament.behaviour.BehaviourUtil;
import de.tomalbrc.filament.data.ItemData;
import de.tomalbrc.filament.item.SimpleItem;
import de.tomalbrc.filament.registry.ItemGroupRegistry;
import de.tomalbrc.filament.util.Constants;
import de.tomalbrc.filament.util.FilamentSynchronousResourceReloadListener;
import de.tomalbrc.filament.util.Json;
import de.tomalbrc.filament.util.RPUtil;
import de.tomalbrc.filament.util.Translations;
import de.tomalbrc.filament.util.Util;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9336;
import org.jetbrains.annotations.Nullable;

public class ItemRegistry {
    public static Map<class_2960, Collection<class_2960>> ITEMS_TAGS = new Object2ReferenceOpenHashMap();

    public static void register(InputStream inputStream) throws IOException {
        JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
        ItemData data = (ItemData)Json.GSON.fromJson(element, ItemData.class);
        Util.handleComponentsCustom(element, data);
        ItemRegistry.register(data);
    }

    public static void register(ItemData data) {
        if (class_7923.field_41178.method_10250(data.id())) {
            return;
        }
        class_1792.class_1793 properties = data.properties().toItemProperties(data.behaviour());
        if (data.properties().copyComponents) {
            for (class_9336 component : data.vanillaItem().method_57347()) {
                properties.method_57349(component.comp_2443(), component.comp_2444());
            }
        }
        for (class_9336 component : data.components()) {
            properties.method_57349(component.comp_2443(), component.comp_2444());
        }
        SimpleItem item = ItemRegistry.registerItem(ItemRegistry.key(data.id()), newProps -> new SimpleItem((class_1792.class_1793)newProps, data, data.vanillaItem()), properties, data.group() != null ? data.group() : Constants.ITEM_GROUP_ID, data.itemTags());
        BehaviourUtil.postInitItem(item, item, data.behaviour());
        Translations.add(item, null, data);
        RPUtil.create(item, data);
        ((FilamentRegistrationEvents.ItemRegistration)FilamentRegistrationEvents.ITEM.invoker()).registered(data, item);
    }

    public static class_5321<class_1792> key(class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id);
    }

    public static <T extends class_1792> T registerItem(class_5321<class_1792> identifier, Function<class_1792.class_1793, T> function, class_1792.class_1793 properties, class_2960 itemGroup, @Nullable Collection<class_2960> tags) {
        class_1792 item = (class_1792)function.apply(properties.method_63686(identifier));
        class_2378.method_39197((class_2378)class_7923.field_41178, identifier, (Object)item);
        ItemGroupRegistry.addItem(itemGroup, item);
        ITEMS_TAGS.put(identifier.method_29177(), tags);
        return (T)item;
    }

    public static class ItemDataReloadListener
    implements FilamentSynchronousResourceReloadListener {
        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"filament", (String)"items");
        }

        public void method_14491(class_3300 resourceManager) {
            this.load("filament/item", null, resourceManager, (id, inputStream) -> {
                try {
                    ItemRegistry.register(inputStream);
                }
                catch (IOException e) {
                    Filament.LOGGER.error("Failed to load item resource \"{}\".", id, (Object)e);
                }
            });
        }
    }
}

