/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.sound;

import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.tomalbrc.filament.sound.MinecraftAssetFetcher;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.extras.api.format.sound.SoundEntry;
import eu.pb4.polymer.resourcepack.extras.api.format.sound.SoundsAsset;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

public class SoundFix {
    public static final Reference2ObjectOpenHashMap<class_2498, class_2498> REMIXES = new Reference2ObjectOpenHashMap();
    public static final ReferenceOpenHashSet<class_2498> SOUND_TYPES = new ReferenceOpenHashSet();
    static String PATH = "assets/minecraft/sounds.json";
    static String VERSION = "1.21.5";

    public static void init() {
        Path outputPath = Path.of("polymer/sounds-" + VERSION + ".json", new String[0]);
        byte[] data = null;
        try {
            if (Files.exists(outputPath, new LinkOption[0])) {
                data = Files.readAllBytes(outputPath);
            } else {
                data = MinecraftAssetFetcher.fetchSoundsJsonForVersion("1.21.5");
                if (data == null) {
                    return;
                }
                Files.write(outputPath, data, new OpenOption[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (data != null) {
            SoundsAsset.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new InputStreamReader(new ByteArrayInputStream(data)))).ifSuccess(pair -> {
                SoundsAsset soundsAsset = (SoundsAsset)pair.getFirst();
                SoundFix.addData(soundsAsset);
            });
        }
    }

    private static void addData(SoundsAsset vanillaSounds) {
        PolymerResourcePackUtils.RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT.register(resourcePackBuilder -> {
            SoundsAsset oldSoundAsset;
            if (!REMIXES.isEmpty()) {
                return;
            }
            SoundEntry empty = SoundEntry.builder().replace(true).build();
            SoundsAsset newSounds = new SoundsAsset((Map)new Object2ObjectArrayMap());
            String oldData = resourcePackBuilder.getStringDataOrSource(PATH);
            if (oldData != null && (oldSoundAsset = SoundsAsset.fromJson((String)oldData)) != null) {
                newSounds.sounds().putAll(oldSoundAsset.sounds());
            }
            for (class_2498 soundType : SOUND_TYPES) {
                newSounds.sounds().put(soundType.method_10595().comp_3319().method_12832(), empty);
                newSounds.sounds().put(soundType.method_10594().comp_3319().method_12832(), empty);
                newSounds.sounds().put(soundType.method_10596().comp_3319().method_12832(), empty);
                newSounds.sounds().put(soundType.method_10593().comp_3319().method_12832(), empty);
                class_2960 breakId = SoundFix.serversideId(soundType.method_10595().comp_3319());
                class_2960 stepId = SoundFix.serversideId(soundType.method_10594().comp_3319());
                class_2960 hitId = SoundFix.serversideId(soundType.method_10596().comp_3319());
                class_2960 fallId = SoundFix.serversideId(soundType.method_10593().comp_3319());
                newSounds.sounds().put(breakId.method_12832(), (SoundEntry)vanillaSounds.sounds().get(soundType.method_10595().comp_3319().method_12832()));
                newSounds.sounds().put(stepId.method_12832(), (SoundEntry)vanillaSounds.sounds().get(soundType.method_10594().comp_3319().method_12832()));
                newSounds.sounds().put(hitId.method_12832(), (SoundEntry)vanillaSounds.sounds().get(soundType.method_10596().comp_3319().method_12832()));
                newSounds.sounds().put(fallId.method_12832(), (SoundEntry)vanillaSounds.sounds().get(soundType.method_10593().comp_3319().method_12832()));
                REMIXES.put((Object)soundType, (Object)new class_2498(soundType.method_10597(), soundType.method_10599(), class_3414.method_47908((class_2960)breakId), class_3414.method_47908((class_2960)stepId), class_3414.method_47908((class_2960)soundType.method_10598().comp_3319()), class_3414.method_47908((class_2960)hitId), class_3414.method_47908((class_2960)fallId)));
            }
            resourcePackBuilder.addData(PATH, newSounds.toBytes());
        });
    }

    private static class_2960 serversideId(class_2960 resourceLocation) {
        return resourceLocation.method_48331(".serverside");
    }
}

