/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.util.FilamentConfig;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8042;
import net.minecraft.class_8104;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class DecorationUtil {
    public static Int2ObjectOpenHashMap<class_1799> VIRTUAL_ENTITY_PICK_MAP = new Int2ObjectOpenHashMap();

    public static void forEachRotated(List<DecorationData.BlockConfig> blockConfigs, class_2338 originBlockPos, float rotation, Consumer<class_2338> consumer) {
        if (blockConfigs != null) {
            for (DecorationData.BlockConfig blockConfig : blockConfigs) {
                Vector3f origin = blockConfig.origin();
                Vector3f size = blockConfig.size();
                int x = 0;
                while ((float)x < size.x()) {
                    int y = 0;
                    while ((float)y < size.y()) {
                        int z = 0;
                        while ((float)z < size.z()) {
                            Vector3f pos = new Vector3f((float)x, (float)y, (float)z).add((Vector3fc)origin);
                            Vector3f offset = pos.mul(rotation % 90.0f != 0.0f ? org.joml.Math.sqrt((float)2.0f) : 1.0f);
                            offset.rotateY((float)Math.PI / 180 * (rotation + (float)(FilamentConfig.getInstance().alternativeBlockPlacement ? 0 : 180)));
                            class_2338 blockPos = new class_2338((class_2382)originBlockPos).method_10069(-org.joml.Math.round((float)offset.x), org.joml.Math.round((float)offset.y), org.joml.Math.round((float)offset.z));
                            consumer.accept(blockPos);
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
        }
    }

    public static Vector2f barrierDimensions(List<DecorationData.BlockConfig> blockConfigs, float rotation) {
        if (!blockConfigs.isEmpty()) {
            ObjectArrayList posList = new ObjectArrayList();
            DecorationUtil.forEachRotated(blockConfigs, class_2338.field_10980, rotation, ((List)posList)::add);
            Optional boundingBox = class_3341.method_35411((Iterable)posList);
            if (boundingBox.isPresent()) {
                return new Vector2f((float)Math.max(((class_3341)boundingBox.get()).method_35414(), ((class_3341)boundingBox.get()).method_14663()), (float)((class_3341)boundingBox.get()).method_14660());
            }
        }
        return new Vector2f();
    }

    public static InteractionElement decorationInteraction(final DecorationBlockEntity blockEntity) {
        final InteractionElement element = new InteractionElement();
        element.setHandler(new VirtualElement.InteractionHandler(){

            public void interactAt(class_3222 player, class_1268 hand, class_243 pos) {
                class_2338 blockPos;
                class_3218 serverLevel = element.getHolder().getAttachment().getWorld();
                if (serverLevel.method_8505((class_1297)player, blockPos = class_2338.method_49638((class_2374)element.getHolder().getAttachment().getPos()))) {
                    blockEntity.interact((class_1657)player, hand, blockEntity.method_11016().method_46558().method_1023(0.0, 0.5, 0.0).method_1019(pos));
                }
            }

            public void attack(class_3222 player) {
                class_3218 serverLevel = element.getHolder().getAttachment().getWorld();
                class_2338 blockPos = class_2338.method_49638((class_2374)element.getHolder().getAttachment().getPos());
                player.field_13974.method_14263(blockPos, class_2846.class_2847.field_12968, class_2350.field_11036, serverLevel.method_31600(), 0);
            }
        });
        if (blockEntity.getDecorationData() != null && blockEntity.getDecorationData().size() != null) {
            element.setSize(blockEntity.getDecorationData().size().x, blockEntity.getDecorationData().size().y);
        } else {
            element.setSize(1.0f, blockEntity.getDirection().equals((Object)class_2350.field_11033) ? 1.0f : 0.5f);
        }
        class_2382 q = blockEntity.getDirection().method_62675();
        if (blockEntity.getDirection() != class_2350.field_11033 && blockEntity.getDirection() != class_2350.field_11036) {
            element.setOffset(new class_243((double)q.method_10263(), (double)((float)q.method_10264() + element.getHeight()), (double)q.method_10260()).method_18805((double)(1.0f - element.getWidth()), 1.0, (double)(1.0f - element.getWidth())).method_1021(-0.5));
        } else {
            element.setOffset(new class_243((double)q.method_10263(), (double)q.method_10264(), (double)q.method_10260()).method_1031(0.0, blockEntity.getDirection() == class_2350.field_11036 ? -1.5 : (double)(0.5f + (1.0f - element.getHeight())), 0.0));
        }
        return element;
    }

    public static InteractionElement decorationInteraction(DecorationData decorationData) {
        final InteractionElement element = new InteractionElement();
        element.setHandler(new VirtualElement.InteractionHandler(){

            public void attack(class_3222 player) {
                class_3218 serverLevel = element.getHolder().getAttachment().getWorld();
                class_2338 blockPos = class_2338.method_49638((class_2374)element.getHolder().getAttachment().getPos());
                player.field_13974.method_14263(blockPos, class_2846.class_2847.field_12968, class_2350.field_11036, serverLevel.method_31600(), 0);
            }
        });
        element.setSize(1.0f, 1.0f);
        if (decorationData.size() != null) {
            element.setSize(decorationData.size().x, decorationData.size().y);
        } else {
            element.setSize(1.0f, 1.0f);
        }
        element.setOffset(new class_243(0.0, -0.5, 0.0));
        return element;
    }

    public static ItemDisplayElement decorationItemDisplay(DecorationBlockEntity blockEntity) {
        ItemDisplayElement display = DecorationUtil.decorationItemDisplay(blockEntity.getDecorationData(), blockEntity.getDirection(), blockEntity.getVisualRotationYInDegrees());
        display.setItem(blockEntity.visualItemStack());
        return display;
    }

    public static ItemDisplayElement decorationItemDisplay(DecorationData data, class_2350 direction, float rotation) {
        ItemDisplayElement itemDisplayElement = new ItemDisplayElement((class_1792)class_7923.field_41178.method_63535(data.id()));
        itemDisplayElement.setTeleportDuration(1);
        if (data != null && data.properties().glow) {
            itemDisplayElement.setBrightness(class_8104.field_42264);
        }
        Vector2f size = new Vector2f(1.0f);
        if (data.hasBlocks()) {
            size = DecorationUtil.barrierDimensions(data.blocks(), rotation);
        } else if (data.size() != null) {
            size = data.size();
        }
        Matrix4f matrix4f = new Matrix4f().identity();
        matrix4f.scale(0.5f);
        if (direction == class_2350.field_11033 || direction == class_2350.field_11036) {
            matrix4f.setTranslation(0.0f, -0.5f, 0.0f);
            float ang = (float)Math.toRadians(rotation + 180.0f);
            double angleRadians = class_3532.method_15349((double)(-class_3532.method_15374((float)ang)), (double)class_3532.method_15362((float)ang));
            matrix4f.rotate((Quaternionfc)class_7833.field_40716.rotation((float)angleRadians).normalize());
            matrix4f.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
            if (direction == class_2350.field_11033) {
                matrix4f.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f));
                matrix4f.setTranslation(0.0f, 0.5f, 0.0f);
            }
        } else {
            double angleRadians = (float)Math.PI / 180 * direction.method_10144();
            Quaternionf rot = class_7833.field_40716.rotation((float)angleRadians).conjugate().normalize();
            matrix4f.rotate((Quaternionfc)rot);
            matrix4f.setTranslation((Vector3fc)new Vector3f(0.0f, 0.0f, -0.5f).rotate((Quaternionfc)rot));
        }
        itemDisplayElement.setDisplayWidth(size.x * 2.0f);
        itemDisplayElement.setDisplayHeight(size.y * 2.0f);
        itemDisplayElement.setTransformation(matrix4f);
        itemDisplayElement.setItemDisplayContext(data.properties().display);
        return itemDisplayElement;
    }

    public static void showBreakParticle(class_3218 level, class_1799 stack, float x, float y, float z) {
        DecorationUtil.showBreakParticle(level, class_259.method_1077(), stack, class_2338.method_49637((double)x, (double)y, (double)z));
    }

    public static void showBreakParticleShaped(class_3218 level, class_2338 blockPos, class_2680 blockState, class_1799 stack) {
        if (blockState.method_26215() || !blockState.method_45475()) {
            return;
        }
        class_265 voxelShape = blockState.method_26218((class_1922)level, blockPos);
        DecorationUtil.showBreakParticle(level, voxelShape, stack, blockPos);
    }

    public static void showBreakParticle(class_3218 level, class_265 voxelShape, class_1799 stack, class_2338 blockPos) {
        double div = 0.25;
        ObjectArrayList packets = new ObjectArrayList();
        voxelShape.method_1089((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> DecorationUtil.lambda$showBreakParticle$0(div, (List)packets, stack, blockPos, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
        if (!packets.isEmpty()) {
            class_8042 bundlePacket = new class_8042((Iterable)packets);
            for (class_3222 player : level.method_18456()) {
                if (!(player.method_19538().method_1022(blockPos.method_46558()) < 512.0)) continue;
                player.field_13987.method_14364((class_2596)bundlePacket);
            }
        }
    }

    public static class_1799 placementAdjustedItem(class_1799 itemStack, ItemResource itemResource, boolean wall, boolean ceiling) {
        class_1799 converted = DecorationUtil.clientsideItem(itemStack);
        if (wall && itemResource.getModels().containsKey("wall")) {
            converted.method_57379(class_9334.field_49637, (Object)new class_9280((List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)"wall"), (List)ImmutableList.of()));
            return converted;
        }
        if (ceiling && itemResource.getModels().containsKey("ceiling")) {
            converted.method_57379(class_9334.field_49637, (Object)new class_9280((List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)"ceiling"), (List)ImmutableList.of()));
            return converted;
        }
        if (itemResource.getModels().containsKey("floor")) {
            converted.method_57379(class_9334.field_49637, (Object)new class_9280((List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)"floor"), (List)ImmutableList.of()));
            return converted;
        }
        converted.method_57381(class_9334.field_49631);
        return converted;
    }

    public static class_1799 clientsideItem(class_1799 itemStack) {
        if (!(itemStack.method_7909() instanceof PolymerItem)) {
            return itemStack.method_46651(1);
        }
        return ((PolymerItem)itemStack.method_7909()).getPolymerItemStack(itemStack, (class_1836)class_1836.field_41070, PacketContext.create((class_7225.class_7874)Filament.REGISTRY_ACCESS.method_45926()));
    }

    private static /* synthetic */ void lambda$showBreakParticle$0(double div, List packets, class_1799 stack, class_2338 blockPos, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double dx = org.joml.Math.min((double)1.0, (double)(maxX - minX));
        double dy = org.joml.Math.min((double)1.0, (double)(maxY - minY));
        double dz = org.joml.Math.min((double)1.0, (double)(maxZ - minZ));
        int nx = org.joml.Math.max((int)2, (int)class_3532.method_15384((double)(dx / div)));
        int ny = org.joml.Math.max((int)2, (int)class_3532.method_15384((double)(dy / div)));
        int nz = org.joml.Math.max((int)2, (int)class_3532.method_15384((double)(dz / div)));
        for (int iX = 0; iX < nx; ++iX) {
            for (int iY = 0; iY < ny; ++iY) {
                for (int iZ = 0; iZ < nz; ++iZ) {
                    double deltaX = ((double)iX + 0.5) / (double)nx;
                    double deltaY = ((double)iY + 0.5) / (double)ny;
                    double deltaZ = ((double)iZ + 0.5) / (double)nz;
                    double xOffset = deltaX * dx + minX;
                    double yOffset = deltaY * dy + minY;
                    double zOffset = deltaZ * dz + minZ;
                    packets.add(new class_2675((class_2394)new class_2392(class_2398.field_11218, stack), true, false, (double)blockPos.method_10263() + xOffset, (double)blockPos.method_10264() + yOffset, (double)blockPos.method_10260() + zOffset, (float)deltaX - 0.5f, (float)deltaY - 0.5f, (float)deltaZ - 0.5f, 0.25f, 0));
                }
            }
        }
    }
}

