/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.gson.annotations.SerializedName;
import de.tomalbrc.filament.util.Constants;
import de.tomalbrc.filament.util.Json;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class FilamentConfig {
    static Path CONFIG_FILE_PATH = Constants.CONFIG_DIR.resolve("filament.json");
    static FilamentConfig instance;
    public boolean debug = false;
    @SerializedName(value="commands")
    public boolean commands = true;
    @SerializedName(value="prevent_adventure_mode_decoration_interaction")
    public boolean preventAdventureModeDecorationInteraction = true;
    @SerializedName(value="alternative_block_placement")
    public boolean alternativeBlockPlacement = false;
    @SerializedName(value="alternative_cosmetic_placement")
    public boolean alternativeCosmeticPlacement = false;
    @SerializedName(value="entity_module")
    public boolean entityModule = true;
    @SerializedName(value="sound_module")
    public boolean soundModule = true;

    public static FilamentConfig getInstance() {
        if (instance == null && !FilamentConfig.load()) {
            FilamentConfig.save();
        }
        return instance;
    }

    public static boolean load() {
        if (!CONFIG_FILE_PATH.toFile().exists()) {
            instance = new FilamentConfig();
            try {
                if (CONFIG_FILE_PATH.toFile().createNewFile()) {
                    FileOutputStream stream = new FileOutputStream(CONFIG_FILE_PATH.toFile());
                    stream.write(Json.GSON.toJson((Object)instance).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        try {
            instance = (FilamentConfig)Json.GSON.fromJson((Reader)new FileReader(CONFIG_FILE_PATH.toFile()), FilamentConfig.class);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private static void save() {
        try {
            FileOutputStream stream = new FileOutputStream(CONFIG_FILE_PATH.toFile());
            stream.write(Json.GSON.toJson((Object)instance).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

