/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.util.Json;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FilamentSynchronousResourceReloadListener
extends SimpleSynchronousResourceReloadListener {
    default public void loadJson(@NotNull String root, @Nullable String endsWith, @NotNull class_3300 resourceManager, @NotNull BiConsumer<class_2960, InputStream> onRead) {
        Map resources = resourceManager.method_14488(root, path -> path.method_12832().endsWith((endsWith == null ? "" : endsWith) + ".json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                try {
                    ByteArrayInputStream stream;
                    Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
                    if (json.isJsonObject()) {
                        Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
                        Map<String, Object> document = (Map<String, Object>)gson.fromJson(json, mapType);
                        if (document != null) {
                            document = Json.camelToSnakeCase(document);
                        }
                        stream = new ByteArrayInputStream(gson.toJson(document).getBytes(StandardCharsets.UTF_8));
                    } else {
                        stream = new ByteArrayInputStream(gson.toJson(json).getBytes(StandardCharsets.UTF_8));
                    }
                    onRead.accept((class_2960)entry.getKey(), stream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | IllegalStateException e) {
                this.error((class_2960)entry.getKey(), e);
            }
        }
    }

    default public void loadYaml(@NotNull String root, @Nullable String endsWith, @NotNull class_3300 resourceManager, @NotNull BiConsumer<class_2960, InputStream> onRead) {
        Map resources = resourceManager.method_14488(root, path -> path.method_12832().endsWith((endsWith == null ? "" : endsWith) + ".yaml") || path.method_12832().endsWith((endsWith == null ? "" : endsWith) + ".yml"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                try {
                    List<InputStream> list = Json.yamlToJson(inputStream);
                    for (InputStream stream : list) {
                        onRead.accept((class_2960)entry.getKey(), stream);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | IllegalStateException e) {
                this.error((class_2960)entry.getKey(), e);
            }
        }
    }

    default public void load(@NotNull String root, @Nullable String endsWith, @NotNull class_3300 resourceManager, @NotNull BiConsumer<class_2960, InputStream> onRead) {
        this.loadYaml(root, endsWith, resourceManager, onRead);
        this.loadJson(root, endsWith, resourceManager, onRead);
    }

    default public void error(class_2960 resourceLocation, Exception e) {
        Filament.LOGGER.error("Failed to load resource \"{}\".", (Object)resourceLocation, (Object)e);
    }
}

