/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.behaviour.BehaviourList;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.snakeyaml.Yaml;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1267;
import net.minecraft.class_1304;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3619;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5955;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Json {
    private static final Set<String> BEHAVIOUR_ALIASES = ImmutableSet.of((Object)"behavior", (Object)"behaviors", (Object)"behaviours");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeHierarchyAdapter(class_2680.class, (Object)new BlockStateDeserializer()).registerTypeHierarchyAdapter(Vector3f.class, (Object)new Vector3fDeserializer()).registerTypeHierarchyAdapter(Vector2f.class, (Object)new Vector2fDeserializer()).registerTypeHierarchyAdapter(Quaternionf.class, (Object)new QuaternionfDeserializer()).registerTypeAdapter(class_2960.class, new SimpleCodecDeserializer(class_2960.field_25139)).registerTypeHierarchyAdapter(class_9323.class, (Object)new DataComponentsDeserializer()).registerTypeHierarchyAdapter(class_1304.class, new LowercaseEnumDeserializer<class_1304>(class_1304.class)).registerTypeHierarchyAdapter(BlockModelType.class, new LowercaseEnumDeserializer<BlockModelType>(BlockModelType.class)).registerTypeHierarchyAdapter(class_1267.class, new LowercaseEnumDeserializer<class_1267>(class_1267.class)).registerTypeHierarchyAdapter(class_1311.class, new LowercaseEnumDeserializer<class_1311>(class_1311.class)).registerTypeHierarchyAdapter(class_811.class, new LowercaseEnumDeserializer<class_811>(class_811.class)).registerTypeHierarchyAdapter(class_3619.class, new LowercaseEnumDeserializer<class_3619>(class_3619.class)).registerTypeHierarchyAdapter(class_5955.class_5811.class, new LowercaseEnumDeserializer<class_5955.class_5811>(class_5955.class_5811.class)).registerTypeHierarchyAdapter(class_2248.class, new RegistryDeserializer(class_7923.field_41175)).registerTypeHierarchyAdapter(class_1792.class, new RegistryDeserializer(class_7923.field_41178)).registerTypeHierarchyAdapter(class_3414.class, new RegistryDeserializer(class_7923.field_41172)).registerTypeHierarchyAdapter(BehaviourConfigMap.class, (Object)new BehaviourConfigMap.Deserializer()).registerTypeHierarchyAdapter(BehaviourList.class, (Object)new BehaviourList.Deserializer()).registerTypeHierarchyAdapter(BlockStateMappedProperty.class, new BlockStateMappedPropertyDeserializer()).registerTypeHierarchyAdapter(PolymerBlockModel.class, (Object)new PolymerBlockModelDeserializer()).create();

    /*
     * WARNING - void declaration
     */
    public static List<InputStream> yamlToJson(InputStream inputStream) {
        Yaml yaml = new Yaml();
        Iterable<Object> documents = yaml.loadAll(inputStream);
        ObjectArrayList list = new ObjectArrayList();
        for (Object object : documents) {
            void var5_5;
            if (object instanceof Map) {
                Map d = (Map)object;
                Map<String, Object> map = Json.camelToSnakeCase(d);
            }
            String jsonString = GSON.toJson((Object)var5_5);
            ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));
            list.add(stream);
        }
        return list;
    }

    public static InputStream camelToSnakeCase(InputStream inputStream) {
        ByteArrayInputStream stream;
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
        if (json.isJsonObject()) {
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map<String, Object> document = (Map<String, Object>)gson.fromJson(json, mapType);
            if (document != null) {
                document = Json.camelToSnakeCase(document);
            }
            stream = new ByteArrayInputStream(gson.toJson(document).getBytes(StandardCharsets.UTF_8));
        } else {
            stream = new ByteArrayInputStream(gson.toJson(json).getBytes(StandardCharsets.UTF_8));
        }
        return stream;
    }

    public static Map<String, Object> camelToSnakeCase(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = Json.camelToSnakeCaseKey(entry.getKey());
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                Map map1;
                Map nestedMap = map1 = (Map)value;
                value = Json.camelToSnakeCase(nestedMap);
            }
            result.put(key, value);
        }
        return result;
    }

    @Nullable
    private static String aliasReplace(String string) {
        if (BEHAVIOUR_ALIASES.contains(string)) {
            return "behaviour";
        }
        return null;
    }

    @NotNull
    private static String camelToSnakeCaseKey(String key) {
        String replacement = Json.aliasReplace(key);
        if (replacement != null) {
            return replacement;
        }
        StringBuilder snakeCase = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                snakeCase.append('_');
            }
            snakeCase.append(Character.toLowerCase(c));
        }
        return snakeCase.toString();
    }

    public static class BlockStateDeserializer
    implements JsonDeserializer<class_2680> {
        public class_2680 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_2259.class_7211 parsed;
            String name = json.getAsString().toLowerCase();
            try {
                parsed = class_2259.method_41957((class_7225)class_7923.field_41175, (String)name, (boolean)false);
            }
            catch (CommandSyntaxException e) {
                throw new JsonParseException("Invalid BlockState value: " + name);
            }
            return parsed.comp_622();
        }
    }

    public static class Vector3fDeserializer
    implements JsonDeserializer<Vector3f> {
        public Vector3f deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (jsonArray.size() < 3) {
                throw new JsonParseException("Array size should be at least 3 for Vector3f deserialization.");
            }
            float x = jsonArray.get(0).getAsFloat();
            float y = jsonArray.get(1).getAsFloat();
            float z = jsonArray.get(2).getAsFloat();
            return new Vector3f(x, y, z);
        }
    }

    public static class Vector2fDeserializer
    implements JsonDeserializer<Vector2f> {
        public Vector2f deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (jsonArray.size() < 2) {
                throw new JsonParseException("Array size should be at least 2 for Vector2f deserialization.");
            }
            float x = jsonArray.get(0).getAsFloat();
            float y = jsonArray.get(1).getAsFloat();
            return new Vector2f(x, y);
        }
    }

    public static class QuaternionfDeserializer
    implements JsonDeserializer<Quaternionf> {
        public Quaternionf deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (jsonArray.size() < 3) {
                throw new JsonParseException("Array size should be at least 3 for euler angle deserialization.");
            }
            float x = jsonArray.get(0).getAsFloat();
            float y = jsonArray.get(1).getAsFloat();
            float z = jsonArray.get(2).getAsFloat();
            return new Quaternionf().rotateXYZ(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), z * ((float)Math.PI / 180));
        }
    }

    public static class SimpleCodecDeserializer<T>
    implements JsonDeserializer<T> {
        private final Codec<T> codec;

        public SimpleCodecDeserializer(Codec<T> codec) {
            this.codec = codec;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (T)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(error -> new JsonParseException("Failed to deserialize using Codec: " + error));
        }
    }

    public static class DataComponentsDeserializer
    implements JsonDeserializer<class_9323> {
        public class_9323 deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            class_6903.class_7863 registryInfoLookup = DataComponentsDeserializer.createContext((class_5455)class_5455.method_40302((class_2378)class_7923.field_41167));
            DataResult result = class_9323.field_50234.decode((DynamicOps)class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)registryInfoLookup), (Object)jsonElement);
            if (result.resultOrPartial().isEmpty()) {
                Filament.LOGGER.error("Skipping broken components; could not load: {}", (Object)jsonElement.toString());
                Filament.LOGGER.error("Minecraft error message: {}", (Object)((DataResult.Error)result.error().orElseThrow()).message());
                return null;
            }
            if (result.error().isPresent()) {
                Filament.LOGGER.warn("Could not load some components: {}", (Object)jsonElement.toString());
                Filament.LOGGER.warn("Minecraft error message: {}", (Object)((DataResult.Error)result.error().orElseThrow()).message());
            }
            return (class_9323)((Pair)result.resultOrPartial().get()).getFirst();
        }

        public static class_6903.class_7863 createContext(class_5455 registryAccess) {
            final HashMap map = new HashMap();
            registryAccess.method_40311().forEach(registryEntry -> map.put(registryEntry.comp_350(), DataComponentsDeserializer.createInfoForContextRegistry(registryEntry.comp_351())));
            return new class_6903.class_7863(){

                @NotNull
                public <T> Optional<class_6903.class_7862<T>> method_46623(class_5321<? extends class_2378<? extends T>> resourceKey) {
                    return Optional.ofNullable((class_6903.class_7862)map.get(resourceKey));
                }
            };
        }

        public static <T> class_6903.class_7862<T> createInfoForContextRegistry(class_2378<T> registry) {
            return new class_6903.class_7862(registry, registry, registry.method_46766());
        }
    }

    public static class LowercaseEnumDeserializer<T extends Enum<T>>
    implements JsonDeserializer<T> {
        private final Class<T> enumClass;

        public LowercaseEnumDeserializer(Class<T> enumClass) {
            this.enumClass = enumClass;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String value = json.getAsString().toLowerCase();
            for (Enum constant : (Enum[])this.enumClass.getEnumConstants()) {
                if (!constant.name().equalsIgnoreCase(value)) continue;
                return (T)constant;
            }
            throw new JsonParseException("Invalid " + this.enumClass.getSimpleName() + " value: " + value);
        }
    }

    private record RegistryDeserializer<T>(class_2378<T> registry) implements JsonDeserializer<T>
    {
        public T deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            return (T)this.registry.method_63535(class_2960.method_60654((String)element.getAsString()));
        }
    }

    public static class BlockStateMappedPropertyDeserializer<T>
    implements JsonDeserializer<BlockStateMappedProperty<T>> {
        public BlockStateMappedProperty<T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = json.getAsJsonPrimitive();
                Type propertyType = ((ParameterizedType)typeOfT).getActualTypeArguments()[0];
                Object t = context.deserialize((JsonElement)primitive, propertyType);
                return new BlockStateMappedProperty<Object>(t);
            }
            if (json.isJsonObject()) {
                ParameterizedType mapType = BlockStateMappedPropertyDeserializer.getParameterizedType((ParameterizedType)typeOfT);
                Map map = (Map)context.deserialize(json, (Type)mapType);
                return new BlockStateMappedProperty(map);
            }
            throw new JsonParseException("Invalid format for MappedProperty");
        }

        @NotNull
        private static ParameterizedType getParameterizedType(ParameterizedType typeOfT) {
            final Type propertyType = typeOfT.getActualTypeArguments()[0];
            return new ParameterizedType(){

                @Override
                public Type @NotNull [] getActualTypeArguments() {
                    return new Type[]{String.class, propertyType};
                }

                @Override
                @NotNull
                public Type getRawType() {
                    return Map.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            };
        }
    }

    public static class PolymerBlockModelDeserializer
    implements JsonDeserializer<PolymerBlockModel> {
        public PolymerBlockModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = json.getAsJsonPrimitive();
                if (primitive.isString()) {
                    return PolymerBlockModel.of((class_2960)class_2960.method_12829((String)primitive.getAsString()));
                }
            } else if (json.isJsonObject()) {
                JsonObject object = json.getAsJsonObject();
                class_2960 model = class_2960.method_60654((String)object.get("model").getAsString());
                int x = object.has("x") ? object.get("x").getAsInt() : 0;
                int y = object.has("y") ? object.get("y").getAsInt() : 0;
                boolean uvLock = object.has("uvLock") && object.get("uvLock").getAsBoolean();
                int weight = object.has("weight") ? object.get("weight").getAsInt() : 1;
                return PolymerBlockModel.of((class_2960)model, (int)x, (int)y, (boolean)uvLock, (int)weight);
            }
            throw new JsonParseException("Invalid PolymerBlockModel value: " + String.valueOf(json));
        }
    }
}

