/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.ItemPredicateModelProvider;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.data.resource.BlockResource;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.data.resource.ResourceProvider;
import de.tomalbrc.filament.generator.ItemAssetGenerator;
import de.tomalbrc.filament.util.Json;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_9334;

public class RPUtil {
    public static void create(BehaviourHolder behaviourHolder, Data data) {
        ItemResource ir;
        Object blockData;
        ResourceProvider itemResources = data.itemResource();
        if (data.itemResource() == null && data instanceof BlockData) {
            blockData = (BlockData)data;
            itemResources = ((BlockData)blockData).blockResource();
        }
        if (itemResources instanceof ItemResource && (ir = itemResources).couldGenerate()) {
            RPUtil.createItemModels(data.id(), ir);
        }
        if (data instanceof BlockData && ((BlockData)(blockData = (BlockData)data)).virtual()) {
            RPUtil.createBlockItemAssets(((Data)blockData).id(), ((BlockData)blockData).blockResource());
        }
        if (itemResources != null && data.itemModel() == null && itemResources.getModels() != null && !data.components().method_57832(class_9334.field_54199)) {
            if (itemResources.getModels().size() > 1) {
                for (Map.Entry entry : behaviourHolder.getBehaviours()) {
                    Object v = entry.getValue();
                    if (!(v instanceof ItemPredicateModelProvider)) continue;
                    ItemPredicateModelProvider modelProvider = (ItemPredicateModelProvider)v;
                    modelProvider.generate(data);
                    return;
                }
            }
            ResourceProvider finalItemResources = itemResources;
            PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> ItemAssetGenerator.createDefault(resourcePackBuilder, data.id(), finalItemResources, data.components().method_57832(class_9334.field_49644) || data.vanillaItem().method_57347().method_57832(class_9334.field_49644)));
        }
    }

    public static void createBlockItemAssets(class_2960 id, BlockResource blockResource) {
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> ItemAssetGenerator.createDefault(resourcePackBuilder, id.method_45138("block/"), blockResource, false));
    }

    private static void createItemModels(class_2960 id, ItemResource itemResource) {
        if (itemResource.couldGenerate()) {
            for (Map.Entry<String, Map<String, class_2960>> entry : itemResource.textures().entrySet()) {
                class_2960 modelId = id.method_45138("item/").method_48331("_" + entry.getKey());
                PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(builder -> {
                    JsonObject object = new JsonObject();
                    object.add("parent", (JsonElement)new JsonPrimitive(itemResource.parent().toString()));
                    JsonObject textures = new JsonObject();
                    for (Map.Entry stringResourceLocationEntry : ((Map)entry.getValue()).entrySet()) {
                        textures.add((String)stringResourceLocationEntry.getKey(), (JsonElement)new JsonPrimitive(((class_2960)stringResourceLocationEntry.getValue()).toString()));
                    }
                    object.add("textures", (JsonElement)textures);
                    builder.addData("assets/" + modelId.method_12836() + "/models/" + modelId.method_12832() + ".json", Json.GSON.toJson((JsonElement)object).getBytes(StandardCharsets.UTF_8));
                });
                itemResource.getModels().put(entry.getKey(), modelId);
            }
        }
    }
}

