/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.item.FilamentItem;
import de.tomalbrc.filament.util.FilamentReloadUtil;
import de.tomalbrc.filament.util.RegistryUnfreezer;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import net.minecraft.class_8013;
import net.minecraft.class_9334;
import xyz.nucleoid.packettweaker.PacketContext;

public class Util {
    public static final class_8013 SEGMENTED_ANGLE8 = new class_8013(3);

    public static Optional<Integer> validateAndConvertHexColor(String hexColor) {
        Pattern hexColorPattern = Pattern.compile("^#?([A-Fa-f0-9]{6})$|^0x([A-Fa-f0-9]{6})$");
        Matcher matcher = hexColorPattern.matcher(hexColor);
        if (matcher.matches()) {
            String hexDigits = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            int intValue = Integer.parseInt(hexDigits, 16);
            return Optional.of(intValue);
        }
        Filament.LOGGER.warn("Invalid hex color formats");
        return Optional.empty();
    }

    public static void spawnAtLocation(class_1937 level, class_243 pos, class_1799 itemStack) {
        if (!itemStack.method_7960() && !level.field_9236) {
            class_1542 itemEntity = new class_1542(level, pos.method_10216(), pos.method_10214(), pos.method_10215(), itemStack);
            itemEntity.method_6988();
            level.method_8649((class_1297)itemEntity);
        }
    }

    public static void loadDatapackContents(class_3300 resourceManager) {
        ((RegistryUnfreezer)class_7923.field_41175).filament$unfreeze();
        ((RegistryUnfreezer)class_7923.field_41178).filament$unfreeze();
        ((RegistryUnfreezer)class_7923.field_41181).filament$unfreeze();
        ((RegistryUnfreezer)class_7923.field_41177).filament$unfreeze();
        ((RegistryUnfreezer)class_7923.field_44687).filament$unfreeze();
        for (SimpleSynchronousResourceReloadListener simpleSynchronousResourceReloadListener : FilamentReloadUtil.getReloadListeners()) {
            simpleSynchronousResourceReloadListener.method_14491(resourceManager);
        }
        ((RegistryUnfreezer)class_7923.field_41175).filament$freeze();
        ((RegistryUnfreezer)class_7923.field_41178).filament$freeze();
        ((RegistryUnfreezer)class_7923.field_41181).filament$freeze();
        ((RegistryUnfreezer)class_7923.field_41177).filament$freeze();
        ((RegistryUnfreezer)class_7923.field_44687).filament$freeze();
    }

    public static void damageAndBreak(int i, class_1799 itemStack, class_1309 livingEntity, class_1304 slot) {
        int newDamage = itemStack.method_7919() + i;
        itemStack.method_7974(newDamage);
        if (newDamage >= itemStack.method_7936()) {
            class_1792 item = itemStack.method_7909();
            itemStack.method_7934(1);
            livingEntity.method_20235(item, slot);
        }
    }

    public static void handleComponentsCustom(JsonElement element, Data data) {
        if (element.getAsJsonObject().has("components")) {
            JsonObject comp = element.getAsJsonObject().get("components").getAsJsonObject();
            if (comp.has("minecraft:jukebox_playable")) {
                data.putAdditional(class_9334.field_52175, comp.getAsJsonObject("minecraft:jukebox_playable"));
            }
            if (comp.has("jukebox_playable")) {
                data.putAdditional(class_9334.field_52175, comp.getAsJsonObject("jukebox_playable"));
            }
        }
    }

    public static class_1799 filamentItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext packetContext, FilamentItem filamentItem) {
        class_1799 stack = PolymerItemUtils.createItemStack((class_1799)itemStack, (class_1836)tooltipType, (PacketContext)packetContext);
        class_2960 dataComponentModel = null;
        if (filamentItem.getData() != null && filamentItem.getData().components().method_57832(class_9334.field_54199)) {
            dataComponentModel = (class_2960)filamentItem.getData().components().method_58694(class_9334.field_54199);
        } else if (filamentItem.getData() != null) {
            if (filamentItem.getData().itemModel() != null) {
                dataComponentModel = filamentItem.getData().itemModel();
            } else {
                class_2960 class_29602 = dataComponentModel = filamentItem.getData().preferredResource() == null ? (class_2960)filamentItem.getData().vanillaItem().method_57347().method_58694(class_9334.field_54199) : null;
            }
        }
        if (dataComponentModel != null) {
            stack.method_57379(class_9334.field_54199, dataComponentModel);
        }
        filamentItem.getDelegate().modifyPolymerItemStack(filamentItem.getModelMap(), itemStack, stack, tooltipType, packetContext.getRegistryWrapperLookup(), packetContext.getPlayer());
        return stack;
    }
}

